'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Popover = require('../src/Popover');
var Input = require('../src/Input');
var Icon = require('../src/Icon');
var Button = require('../src/Button');

var SCOPE = { React: React, Panel: Panel, Popover: Popover, Button: Button, Input: Input, Icon: Icon };

var EXAMPLE_IMPORT = 'const Popover = require(\'gitbook-styleguide/lib/Popover\');';

var EXAMPLE_DEFAULT = '<Popover>\n    <Popover.Heading title="Hello" />\n    <Popover.Body>\n        Inner body of the popover.\n    </Popover.Body>\n    <Popover.Controls>\n        <Popover.Control active onClick={event => alert(\'Hello\')}>\n            Say Hello\n        </Popover.Control>\n        <Popover.Control onClick={event => alert(\'World\')}>\n            Say World\n        </Popover.Control>\n    </Popover.Controls>\n</Popover>';

var EXAMPLE_WITH_INPUT = '<Popover>\n    <Popover.Heading>\n        <Popover.Title>\n            <Icon id="pencil" /> Edit title\n        </Popover.Title>\n    </Popover.Heading>\n    <Popover.Body>\n        <Input placeholder="Some title" />\n    </Popover.Body>\n</Popover>';

var EXAMPLE_BUTTON = '<Popover.Container>\n    <Button onClick={event => this.setState({ open: !this.state.open })}>\n        Toggle Popover\n    </Button>\n    {this.state.open? (<Popover>\n        <Popover.Heading title="Hello" />\n        <Popover.Body>\n            Inner body of the popover.\n        </Popover.Body>\n    </Popover>) : null}\n</Popover.Container>';

var EXAMPLE_POSITION = '<div>{\n    [\n        \'top\',\n        \'top-right\',\n        \'right\',\n        \'bottom-right\',\n        \'bottom\',\n        \'bottom-left\',\n        \'left\',\n        \'top-left\'\n    ].map(pos =>\n        <Popover.Container key={pos}\n                           onMouseEnter={() => this.setState({ [pos]: true })}\n                           onMouseLeave={() => this.setState({ [pos]: false })}>\n            <Button >\n                {pos}\n            </Button>\n            { this.state[pos] ?\n            <Popover position={pos}>\n                <Popover.Body>{pos}</Popover.Body>\n            </Popover>\n            : null }\n        </Popover.Container>\n    )\n}</div>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Popovers', active: 'popovers' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Popovers' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Add small overlay content, like those found in iOS, to any element for housing secondary information.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With an input', source: EXAMPLE_WITH_INPUT, scope: SCOPE }),
        React.createElement(Example, { title: 'With button and state', source: EXAMPLE_BUTTON, scope: SCOPE }),
        React.createElement(Example, { title: 'With custom positioning', source: EXAMPLE_POSITION, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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