'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');
var DIRECTIONS = ['left', 'right'];

var Checkbox = React.createClass({
    displayName: 'Checkbox',


    propTypes: {
        children: React.PropTypes.node,
        checked: React.PropTypes.bool,
        defaultChecked: React.PropTypes.bool,
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        displaySwitch: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        direction: React.PropTypes.oneOf(DIRECTIONS)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            displaySwitch: true,
            size: SIZES[0],
            direction: DIRECTIONS[0]
        };
    },
    onSwitchClick: function onSwitchClick(event) {
        event.stopPropagation();
        this.refs.checkbox.click();
    },
    render: function render() {
        var _props = this.props,
            size = _props.size,
            displaySwitch = _props.displaySwitch,
            direction = _props.direction,
            children = _props.children,
            props = _objectWithoutProperties(_props, ['size', 'displaySwitch', 'direction', 'children']);

        var className = classNames('checkbox', 'switch-' + size, 'switch-' + direction, {
            'checkbox-switch': displaySwitch
        });

        return React.createElement(
            'div',
            { className: className },
            React.createElement(
                'label',
                { htmlFor: this.props.name },
                React.createElement('input', _extends({
                    ref: 'checkbox',
                    type: 'checkbox'
                }, props)),
                displaySwitch ? React.createElement('span', { onClick: this.onSwitchClick }) : null,
                React.createElement(
                    'div',
                    { className: 'checkbox-inline-label', onClick: this.onSwitchClick },
                    children
                )
            )
        );
    }
});

module.exports = Checkbox;
//# sourceMappingURL=data:application/json;base64,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