'use strict';

var React = require('react');
var classNames = require('classnames');

var ListItem = React.createClass({
    displayName: 'ListItem',

    propTypes: {
        active: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        onClick: React.PropTypes.func,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: '#'
        };
    },
    onClick: function onClick(e) {
        if (!this.props.onClick) {
            return;
        }

        e.preventDefault();
        this.props.onClick();
    },
    render: function render() {
        var className = classNames('list-group-item', this.props.className, {
            active: this.props.active
        });

        return React.createElement(
            'a',
            { href: this.props.href, className: className, onClick: this.onClick },
            this.props.children
        );
    }
});

var ListGroup = React.createClass({
    displayName: 'ListGroup',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'ul',
            { className: 'list-group' },
            this.props.children
        );
    }
});

module.exports = ListGroup;
module.exports.Item = ListItem;
//# sourceMappingURL=data:application/json;base64,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