"use strict";

var React = require('react');

var CountWidget = React.createClass({
    displayName: "CountWidget",

    propTypes: {
        left: React.PropTypes.number.isRequired,
        right: React.PropTypes.number.isRequired,
        // min-width for rendered element
        minWidth: React.PropTypes.number
    },

    render: function render() {
        var _props = this.props,
            left = _props.left,
            right = _props.right,
            minWidth = _props.minWidth;

        // Total count

        var total = left + right;

        var countHalfStyle = {};
        if (minWidth) {
            countHalfStyle.minWidth = minWidth / 2 + "px";
        }

        return React.createElement(
            "div",
            { className: "CountWidget" },
            React.createElement(
                "div",
                { className: "CountHalf", style: countHalfStyle },
                React.createElement(
                    "div",
                    { className: "CountValue" },
                    left
                ),
                React.createElement(
                    "span",
                    { className: "CountBar CountBar-Left", style: { width: 100 * left / total + "%" } },
                    React.createElement("div", { className: "CountMeter" })
                )
            ),
            React.createElement(
                "div",
                { className: "CountHalf", style: countHalfStyle },
                React.createElement(
                    "div",
                    { className: "CountValue" },
                    right
                ),
                React.createElement(
                    "span",
                    { className: "CountBar CountBar-Right", style: { width: 100 * right / total + "%" } },
                    React.createElement("div", { className: "CountMeter" })
                )
            )
        );
    }
});

module.exports = CountWidget;
//# sourceMappingURL=data:application/json;base64,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