webpackHotUpdate(16,{

/***/ 613:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, __resourceQuery) {

var _require = __webpack_require__(6),
    List = _require.List;

var React = __webpack_require__(2);
var Slate = __webpack_require__(51);
var Prism = __webpack_require__(397);
var EditCode = __webpack_require__(385);
__webpack_require__(366);

var prism = Prism({
    onlyIn: function onlyIn(node) {
        return node.type == 'code_block';
    },
    getSyntax: function getSyntax(node) {
        return 'jsx';
    }
});

var editCode = EditCode({
    allowMarks: false,
    containerType: 'code_block',
    exitBlockType: null,
    lineType: 'code_line',
    selectAll: false
});

var plugins = [prism, editCode];

var CodeEditor = React.createClass({
    displayName: 'CodeEditor',

    propTypes: {
        source: React.PropTypes.string,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            source: ''
        };
    },

    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        // Reset the key generate to fix potential server side issue

        Slate.resetKeyGenerator();

        var codeBlock = editCode.utils.deserializeCode(source);
        var document = Slate.Document.create({ nodes: List([codeBlock]) });

        return {
            state: Slate.State.create({ document: document })
        };
    },

    // Editor has been modified
    onChange: function onChange(state) {
        var source = state.document.getTexts().map(function (t) {
            return t.text;
        }).join('\n');

        this.setState({ state: state });
        this.props.onChange(source);
    },
    render: function render() {
        var state = this.state.state;

        return React.createElement('pre', null, React.createElement(Slate.Editor, {
            spellCheck: false,
            state: state,
            plugins: plugins,
            onChange: this.onChange
        }));
    }
});

module.exports = CodeEditor;

 ;(function register() { /* react-hot-loader/webpack */ if (process.env.NODE_ENV !== 'production') { if (typeof __REACT_HOT_LOADER__ === 'undefined') { return; } if (typeof module.exports === 'function') { __REACT_HOT_LOADER__.register(module.exports, 'module.exports', "/Users/samypesse/Projects/GitBook/styleguide/pages/components/CodeEditor.js"); return; } for (var key in module.exports) { if (!Object.prototype.hasOwnProperty.call(module.exports, key)) { continue; } var namedExport = void 0; try { namedExport = module.exports[key]; } catch (err) { continue; } __REACT_HOT_LOADER__.register(namedExport, key, "/Users/samypesse/Projects/GitBook/styleguide/pages/components/CodeEditor.js"); } } })();
    (function (Component, route) {
      if (false) return
      if (false) return

      var qs = __webpack_require__(54)
      var params = qs.parse(__resourceQuery.slice(1))
      if (params.entry == null) return

      module.hot.accept()
      Component.__route = route

      if (module.hot.status() === 'idle') return

      var components = next.router.components
      for (var r in components) {
        if (!components.hasOwnProperty(r)) continue

        if (components[r].Component.__route === route) {
          next.router.update(r, Component)
        }
      }
    })(module.exports.default || module.exports, "/components/CodeEditor")
  
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(0), "?entry"))

/***/ })

})
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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