webpackHotUpdate(7,{

/***/ 183:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, __resourceQuery) {

var _require = __webpack_require__(6),
    List = _require.List;

var React = __webpack_require__(2);
var Slate = __webpack_require__(51);
var Prism = __webpack_require__(397);
var EditCode = __webpack_require__(385);
__webpack_require__(366);

var prism = Prism({
    onlyIn: function onlyIn(node) {
        return node.type == 'code_block';
    },
    getSyntax: function getSyntax(node) {
        return 'jsx';
    }
});

var editCode = EditCode({
    allowMarks: false,
    containerType: 'code_block',
    exitBlockType: null,
    lineType: 'code_line',
    selectAll: false
});

var plugins = [prism, editCode];

var CodeEditor = React.createClass({
    displayName: 'CodeEditor',

    propTypes: {
        source: React.PropTypes.string,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            source: ''
        };
    },

    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        // Reset the key generate to fix potential server side issue

        Slate.resetKeyGenerator();

        var codeBlock = editCode.utils.deserializeCode(source);
        var document = Slate.Document.create({ nodes: List([codeBlock]) });

        return {
            state: Slate.State.create({ document: document })
        };
    },

    // Editor has been modified
    onChange: function onChange(state) {
        var source = state.document.getTexts().map(function (t) {
            return t.text;
        }).join('\n');

        this.setState({ state: state });
        this.props.onChange(source);
    },
    render: function render() {
        var state = this.state.state;

        return React.createElement('pre', null, React.createElement(Slate.Editor, {
            spellCheck: false,
            state: state,
            plugins: plugins,
            onChange: this.onChange
        }));
    }
});

module.exports = CodeEditor;

 ;(function register() { /* react-hot-loader/webpack */ if (process.env.NODE_ENV !== 'production') { if (typeof __REACT_HOT_LOADER__ === 'undefined') { return; } if (typeof module.exports === 'function') { __REACT_HOT_LOADER__.register(module.exports, 'module.exports', "/Users/samypesse/Projects/GitBook/styleguide/pages/components/CodeEditor.js"); return; } for (var key in module.exports) { if (!Object.prototype.hasOwnProperty.call(module.exports, key)) { continue; } var namedExport = void 0; try { namedExport = module.exports[key]; } catch (err) { continue; } __REACT_HOT_LOADER__.register(namedExport, key, "/Users/samypesse/Projects/GitBook/styleguide/pages/components/CodeEditor.js"); } } })();
    (function (Component, route) {
      if (false) return
      if (true) return

      var qs = __webpack_require__(54)
      var params = qs.parse(__resourceQuery.slice(1))
      if (params.entry == null) return

      module.hot.accept()
      Component.__route = route

      if (module.hot.status() === 'idle') return

      var components = next.router.components
      for (var r in components) {
        if (!components.hasOwnProperty(r)) continue

        if (components[r].Component.__route === route) {
          next.router.update(r, Component)
        }
      }
    })(module.exports.default || module.exports, "/components/CodeEditor")
  
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(0), ""))

/***/ })

})
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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