'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Avatar = require('../src/Avatar');
var AvatarsStack = require('../src/AvatarsStack');

var SCOPE = { React: React, Avatar: Avatar, AvatarsStack: AvatarsStack };

var EXAMPLE_IMPORT = 'const Avatar = require(\'gitbook-styleguide/lib/Avatar\');\nconst AvatarsStack = require(\'gitbook-styleguide/lib/AvatarsStack\');';

var EXAMPLE_DEFAULT = '<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-1.png"\n    size="lg"\n    />\n<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-3.png"\n    size="md"\n    />\n<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-4.png"\n    size="sm"\n    />';

var EXAMPLE_STACK = '<AvatarsStack>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-1.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-3.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-4.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n</AvatarsStack>';

exports.default = function () {
    return React.createElement(Page, { title: 'Avatars', active: 'avatars' }, React.createElement(Panel, null, React.createElement(Panel.Heading, { title: 'Avatars' }), React.createElement(Panel.Body, null, React.createElement('p', null), React.createElement(CodeEditor, { source: EXAMPLE_IMPORT }))), React.createElement(Example, { title: 'Layout', source: EXAMPLE_DEFAULT, scope: SCOPE }), React.createElement(Example, { title: 'Stack', source: EXAMPLE_STACK, scope: SCOPE }, 'Stack of avatars can be used to display a list of participants.'));
};