'use strict';

var _require = require('immutable'),
    List = _require.List;

var React = require('react');
var Slate = require('slate');
var Prism = require('slate-prism');
var EditCode = require('slate-edit-code');
require('prismjs/components/prism-jsx');

var prism = Prism({
    onlyIn: function onlyIn(node) {
        return node.type == 'code_block';
    },
    getSyntax: function getSyntax(node) {
        return 'jsx';
    }
});

var editCode = EditCode({
    allowMarks: false,
    containerType: 'code_block',
    exitBlockType: null,
    lineType: 'code_line',
    selectAll: false
});

var plugins = [prism, editCode];

var CodeEditor = React.createClass({
    displayName: 'CodeEditor',

    propTypes: {
        source: React.PropTypes.string,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            source: ''
        };
    },

    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        // Reset the key generate to fix potential server side issue

        Slate.resetKeyGenerator();

        var codeBlock = editCode.utils.deserializeCode(source);
        var document = Slate.Document.create({ nodes: List([codeBlock]) });

        return {
            state: Slate.State.create({ document: document })
        };
    },

    // Editor has been modified
    onChange: function onChange(state) {
        var source = state.document.getTexts().map(function (t) {
            return t.text;
        }).join('\n');

        this.setState({ state: state });
        this.props.onChange(source);
    },
    render: function render() {
        var state = this.state.state;

        return React.createElement('pre', null, React.createElement(Slate.Editor, {
            spellCheck: false,
            state: state,
            plugins: plugins,
            onChange: this.onChange
        }));
    }
});

module.exports = CodeEditor;