'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Dropdown = require('../src/Dropdown');
var Button = require('../src/Button');
var ContextMenu = require('../src/ContextMenu');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Dropdown: Dropdown, Button: Button, Icon: Icon, ContextMenu: ContextMenu };

var EXAMPLE_IMPORT = 'const Dropdown = require(\'gitbook-styleguide/lib/Dropdown\')';
var EXAMPLE_DEFAULT = '<Dropdown>\n    <Button>\n        Toggle dropdown <Button.Caret />\n    </Button>\n    <Dropdown.Header>Account</Dropdown.Header>\n    <Dropdown.Item href="/profile">Profile</Dropdown.Item>\n    <Dropdown.Item href="/settings">Settings</Dropdown.Item>\n    <Dropdown.Divider />\n    <Dropdown.Item onClick={e => alert(\'Logout\')}>Logout</Dropdown.Item>\n</Dropdown>';

var EXAMPLE_CONTEXTMENU = '<ContextMenu component={() => (\n    <ContextMenu.Menu>\n        <ContextMenu.Header>Account</ContextMenu.Header>\n        <ContextMenu.Item href="/profile">Profile</ContextMenu.Item>\n        <ContextMenu.Item href="/settings">Settings</ContextMenu.Item>\n        <ContextMenu.Divider />\n        <ContextMenu.Item onClick={e => alert(\'Logout\')}>Logout</ContextMenu.Item>\n    </ContextMenu.Menu>\n)}>\n    <div>Left click</div>\n</ContextMenu>';

exports.default = function () {
    return React.createElement(Page, { title: 'Dropdowns', active: 'dropdowns' }, React.createElement(Panel, null, React.createElement(Panel.Heading, { title: 'Dropdowns' }), React.createElement(Panel.Body, null, React.createElement(CodeEditor, { source: EXAMPLE_IMPORT }))), React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE }), React.createElement(Example, { title: 'Context Menu', source: EXAMPLE_CONTEXTMENU, scope: SCOPE }));
};