'use strict';

var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }return target;
};

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var Container = require('./Container');
var STYLES = require('./STYLES');

var Alert = React.createClass({
    displayName: 'Alert',

    propTypes: {
        onClose: React.PropTypes.func,
        closable: React.PropTypes.bool,
        style: React.PropTypes.oneOf(STYLES),
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            opened: true
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            onClose: undefined,
            closable: false,
            style: STYLES[0]
        };
    },
    onClose: function onClose(e) {
        e.preventDefault();
        var onClose = this.props.onClose;

        this.setState({
            opened: false
        }, function () {
            if (onClose) onClose();
        });
    },
    render: function render() {
        var style = this.props.style;
        var className = classNames('alert', 'alert-' + style, this.props.className);
        var onClose = this.props.onClose;
        var closable = this.props.closable;
        var inner = void 0;

        if (!this.state.opened) {
            return React.createElement('div', null);
        }

        if (onClose || closable) {
            inner = React.createElement('a', { href: '#', onClick: this.onClose, className: 'alert-btn' }, React.createElement(Icon, { id: 'x' }));
        }

        return React.createElement('div', { className: className }, React.createElement(Container, { fluid: true }, inner, this.props.children));
    }
});

var AlertButton = React.createClass({
    displayName: 'AlertButton',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string,
        href: React.PropTypes.string,
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            e.preventDefault();
            this.props.onClick();
        }
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            className = _props.className;

        className = classNames('alert-btn', className || '');
        href = href || '#';

        return React.createElement('a', { className: className, href: href, onClick: this.onClick }, this.props.children);
    }
});

/**
 * Create a style of alert
 * @param {String} style
 * @return {React.Component}
 */
function createAlertStyle(style) {
    return React.createClass({
        displayName: Alert.displayName + style,
        render: function render() {
            return React.createElement(Alert, _extends({}, this.props, { style: style.toLowerCase() }));
        }
    });
}

module.exports = Alert;
module.exports.Button = AlertButton;
module.exports.Info = createAlertStyle('Info');
module.exports.Danger = createAlertStyle('Danger');
module.exports.Success = createAlertStyle('Success');
module.exports.Warning = createAlertStyle('Warning');