'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');
var AVATAR_SIZES = SIZES.concat(['button']);

var Avatar = React.createClass({
    displayName: 'Avatar',

    propTypes: {
        src: React.PropTypes.string,
        // No src fallbacks on text
        text: React.PropTypes.string,
        size: React.PropTypes.oneOf(AVATAR_SIZES),
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            src = _props.src,
            size = _props.size,
            className = _props.className,
            text = _props.text,
            children = _props.children;

        className = classNames('avatar', size ? 'avatar-' + size : '', className);

        return React.createElement('figure', { className: className, 'data-initial': text }, src ? React.createElement('img', { src: src }) : null, children);
    }
});

var AvatarIcon = React.createClass({
    displayName: 'AvatarIcon',

    propTypes: {
        src: React.PropTypes.string,
        className: React.PropTypes.string
    },

    render: function render() {
        var _props2 = this.props,
            src = _props2.src,
            className = _props2.className;

        className = classNames('avatar-icon', className);

        return React.createElement('img', { src: src, className: className });
    }
});

module.exports = Avatar;
module.exports.Icon = AvatarIcon;