'use strict';

var React = require('react');
var ReactDOM = require('react-dom');

// left: 37, up: 38, right: 39, down: 40,
// spacebar: 32, pageup: 33, pagedown: 34, end: 35, home: 36
var SCROLLING_KEYS = {
    37: 1,
    38: 1,
    39: 1,
    40: 1
};

/**
 * Backdrop for modals, dropdown, popover.
 *
 *
 * For example:
 *
 * <Backdrop onClose={onClosePopover}>
 *      <Popover>...</Popover>
 * </Backdrop>
 */
var Backdrop = React.createClass({
    displayName: 'Backdrop',

    propTypes: {
        // Scroll is enabled ?
        scroll: React.PropTypes.bool,
        // Close on escape
        escape: React.PropTypes.bool,
        // Z-index for the backdrop
        zIndex: React.PropTypes.number,
        // Callback when backdrop is closed
        onClose: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired,
        wrapper: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            scroll: false,
            escape: true,
            zIndex: 200,
            wrapper: React.createElement('div', null)
        };
    },
    onClose: function onClose() {
        var onClose = this.props.onClose;

        onClose();
    },

    /**
     * Clicking should close the backdrop.
     */
    onClick: function onClick(event) {
        event.stopPropagation();
        event.preventDefault();
        this.onClose();
    },

    /**
     * Escape should close the backdrop
     */
    onKeyDown: function onKeyDown(event) {
        var escape = this.props.escape;

        if (event.keyCode === 27 && escape) {
            this.onClose();
        }

        if (SCROLLING_KEYS[event.keyCode]) {
            event.preventDefault();
            return false;
        }
    },

    /**
     * Prevent scroll on wrapper itself.
     */
    onScroll: function onScroll(event) {
        var scroll = this.props.scroll;

        if (scroll) {
            return;
        }

        var container = ReactDOM.findDOMNode(this.refs.wrapper);
        var backdrop = ReactDOM.findDOMNode(this.refs.backdrop);

        if (event.target == container || event.target == backdrop) {
            event.preventDefault();
            event.stopPropagation();
        }
    },
    bindEvents: function bindEvents() {
        var container = ReactDOM.findDOMNode(this.refs.wrapper);

        window.addEventListener('keydown', this.onKeyDown);
        container.addEventListener('scroll', this.onScroll);
        container.addEventListener('wheel', this.onScroll);
    },
    unbindEvents: function unbindEvents() {
        var container = ReactDOM.findDOMNode(this.refs.wrapper);

        window.removeEventListener('keydown', this.onKeyDown);
        container.removeEventListener('scroll', this.onScroll);
        container.removeEventListener('wheel', this.onScroll);
    },
    componentDidMount: function componentDidMount() {
        this.bindEvents();
    },
    componentWillUpdate: function componentWillUpdate() {
        this.unbindEvents();
    },
    componentDidUpdate: function componentDidUpdate() {
        this.bindEvents();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.unbindEvents();
    },
    render: function render() {
        var _props = this.props,
            zIndex = _props.zIndex,
            wrapper = _props.wrapper,
            children = _props.children;

        var style = {
            zIndex: zIndex,
            position: 'fixed',
            top: 0,
            right: 0,
            width: '100%',
            height: '100%'
        };

        return React.cloneElement(wrapper, { ref: 'wrapper' }, React.createElement('div', {
            className: 'Backdrop',
            ref: 'backdrop',
            style: style,
            onClick: this.onClick
        }), wrapper.props.children, children);
    }
});

module.exports = Backdrop;