'use strict';

var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }return target;
};

function _objectWithoutProperties(obj, keys) {
    var target = {};for (var i in obj) {
        if (keys.indexOf(i) >= 0) continue;if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;target[i] = obj[i];
    }return target;
}

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');
var DIRECTIONS = ['left', 'right'];

var Checkbox = React.createClass({
    displayName: 'Checkbox',

    propTypes: {
        children: React.PropTypes.node,
        checked: React.PropTypes.bool,
        defaultChecked: React.PropTypes.bool,
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        displaySwitch: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        direction: React.PropTypes.oneOf(DIRECTIONS)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            displaySwitch: true,
            size: SIZES[0],
            direction: DIRECTIONS[0]
        };
    },
    onSwitchClick: function onSwitchClick(event) {
        event.stopPropagation();
        this.refs.checkbox.click();
    },
    render: function render() {
        var _props = this.props,
            size = _props.size,
            displaySwitch = _props.displaySwitch,
            direction = _props.direction,
            children = _props.children,
            props = _objectWithoutProperties(_props, ['size', 'displaySwitch', 'direction', 'children']);

        var className = classNames('checkbox', 'switch-' + size, 'switch-' + direction, {
            'checkbox-switch': displaySwitch
        });

        return React.createElement('div', { className: className }, React.createElement('label', { htmlFor: this.props.name }, React.createElement('input', _extends({
            ref: 'checkbox',
            type: 'checkbox'
        }, props)), displaySwitch ? React.createElement('span', { onClick: this.onSwitchClick }) : null, React.createElement('div', { className: 'checkbox-inline-label', onClick: this.onSwitchClick }, children)));
    }
});

module.exports = Checkbox;