'use strict';

var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }return target;
};

function _objectWithoutProperties(obj, keys) {
    var target = {};for (var i in obj) {
        if (keys.indexOf(i) >= 0) continue;if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;target[i] = obj[i];
    }return target;
}

var React = require('react');
var classNames = require('classnames');

var Container = React.createClass({
    displayName: 'Container',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        // No hoz padding
        fluid: React.PropTypes.bool,
        // Take all the width
        maxWidth: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            maxWidth: false,
            fluid: false
        };
    },
    render: function render() {
        var _props = this.props,
            fluid = _props.fluid,
            className = _props.className,
            maxWidth = _props.maxWidth,
            props = _objectWithoutProperties(_props, ['fluid', 'className', 'maxWidth']);

        className = classNames('container', {
            'container-fluid': fluid,
            'container-max-width': maxWidth
        }, className);

        return React.createElement('div', _extends({}, props, { className: className }), this.props.children);
    }
});

module.exports = Container;