'use strict';

var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }return target;
};

var React = require('react');
var classNames = require('classnames');

/**
 * Main container for a form
 * @type {ReactClass}
 */
var Form = React.createClass({
    displayName: 'Form',

    propTypes: {
        children: React.PropTypes.node
    },

    submit: function submit() {
        this.refs.form.submit();
    },
    render: function render() {
        return React.createElement('form', _extends({ ref: 'form' }, this.props), this.props.children);
    }
});

/**
 * Container for an input, its label and help text.
 * @type {ReactClass}
 */
var FormGroup = React.createClass({
    displayName: 'FormGroup',

    propTypes: {
        error: React.PropTypes.bool,
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaulProps: function getDefaulProps() {
        return {
            error: false
        };
    },
    render: function render() {
        var className = classNames('form-group', {
            'has-error': this.props.error
        }, this.props.className);

        return React.createElement('div', { className: className }, this.props.children);
    }
});

/**
 * An help text for an input
 * @type {ReactClass}
 */
var FormHelpBlock = React.createClass({
    displayName: 'FormHelpBlock',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement('p', { className: 'help-block' }, this.props.children);
    }
});

/**
 * Container for submit/cancel actions
 * @type {ReactClass}
 */
var FormActions = React.createClass({
    displayName: 'FormActions',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement('div', { className: 'form-actions' }, this.props.children);
    }
});

module.exports = Form;
module.exports.Actions = FormActions;
module.exports.Group = FormGroup;
module.exports.HelpBlock = FormHelpBlock;