'use strict';

var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }return target;
};

function _objectWithoutProperties(obj, keys) {
    var target = {};for (var i in obj) {
        if (keys.indexOf(i) >= 0) continue;if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;target[i] = obj[i];
    }return target;
}

var React = require('react');
var classNames = require('classnames');

var Link = React.createClass({
    displayName: 'Link',

    propTypes: {
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        muted: React.PropTypes.bool,
        underlined: React.PropTypes.bool,
        onClick: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            href: '#'
        };
    },
    onClick: function onClick(e) {
        var onClick = this.props.onClick;

        if (onClick) {
            e.preventDefault();
            onClick(e);
        }
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            className = _props.className,
            children = _props.children,
            muted = _props.muted,
            underlined = _props.underlined,
            onClick = _props.onClick,
            props = _objectWithoutProperties(_props, ['href', 'className', 'children', 'muted', 'underlined', 'onClick']);

        className = classNames(className, {
            'muted-link': muted,
            'underlined-link': underlined
        });

        return React.createElement('a', _extends({ className: className,
            href: href,
            onClick: this.onClick
        }, props), children);
    }
});

module.exports = Link;