'use strict';

var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }return target;
};

function _objectWithoutProperties(obj, keys) {
    var target = {};for (var i in obj) {
        if (keys.indexOf(i) >= 0) continue;if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;target[i] = obj[i];
    }return target;
}

var React = require('react');
var classNames = require('classnames');

var Link = require('./Link');

var POSITIONS = ['top', 'top-right', 'right', 'bottom-right', 'bottom', 'bottom-left', 'left', 'top-left'];

/**
 * Pop content with controls over content:
 *
 * <Popover.Container>
 *   <Button>Open</Button>
 *   {open?
 *      <Popover>
 *         <Popover.Heading title="Hello" />
 *         <Popover.Body>...</Popover.Body>
 *         <Popover.Controls>
 *           <Popover.Control onClick={...}>Say Hello</Popover.Control>
 *           <Popover.Control onClick={...}>Say World</Popover.Control>
 *         </Popover.Controls>
 *      </Popover>
 *   : null}
 * </Popover.Container>
 */

var Popover = React.createClass({
    displayName: 'Popover',

    propTypes: {
        position: React.PropTypes.oneOf(POSITIONS),
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            position: 'bottom'
        };
    },
    render: function render() {
        var position = this.props.position;

        var className = classNames('popover', 'popover-' + position);

        return React.createElement('div', { className: 'popover-wrapper' }, React.createElement('div', { className: className }, React.createElement(PopoverCard, null, React.createElement('div', { className: 'popover-arrow' }), this.props.children)));
    }
});

var PopoverContainer = React.createClass({
    displayName: 'PopoverContainer',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            className = _props.className,
            props = _objectWithoutProperties(_props, ['className']);

        className = classNames('popover-container', className);

        return React.createElement('div', _extends({ className: className }, props), this.props.children);
    }
});

// The actual element that looks like a popup card.
var PopoverCard = React.createClass({
    displayName: 'PopoverCard',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement('div', _extends({ className: 'popover-card' }, this.props), this.props.children);
    }
});

var PopoverBody = React.createClass({
    displayName: 'PopoverBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement('div', { className: 'popover-body' }, this.props.children);
    }
});

var PopoverTitle = React.createClass({
    displayName: 'PopoverTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement('div', { className: 'popover-title' }, this.props.children);
    }
});

var PopoverHeading = React.createClass({
    displayName: 'PopoverHeading',

    propTypes: {
        title: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props2 = this.props,
            title = _props2.title,
            children = _props2.children;

        if (title) {
            children = React.createElement(PopoverTitle, null, title);
        }

        return React.createElement('div', { className: 'popover-heading' }, children);
    }
});

var PopoverControl = React.createClass({
    displayName: 'PopoverControl',

    propTypes: {
        children: React.PropTypes.node,
        onClick: React.PropTypes.func,
        active: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            onClick = _props3.onClick,
            children = _props3.children,
            active = _props3.active;

        var className = classNames('control', { active: active });

        return React.createElement(Link, { className: className, onClick: onClick }, children);
    }
});

var PopoverControls = React.createClass({
    displayName: 'PopoverControls',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement('div', { className: 'popover-controls' }, this.props.children);
    }
});

module.exports = Popover;
module.exports.Card = PopoverCard;
module.exports.Body = PopoverBody;
module.exports.Heading = PopoverHeading;
module.exports.Title = PopoverTitle;
module.exports.Container = PopoverContainer;
module.exports.Control = PopoverControl;
module.exports.Controls = PopoverControls;