'use strict';

var React = require('react');
var classNames = require('classnames');

var POSITIONS = {
    BOTTOM_RIGHT: 'e',
    BOTTOM_LEFT: 'w',
    TOP_LEFT: 'nw',
    TOP_RIGHT: 'ne',
    BOTTOM: '',
    TOP: 'n'
};

var Tooltip = React.createClass({
    displayName: 'Tooltip',

    propTypes: {
        title: React.PropTypes.string.isRequired,
        position: React.PropTypes.string,
        open: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            open: false,
            position: POSITIONS.BOTTOM
        };
    },
    render: function render() {
        var className = classNames('tooltipped-overlay', 'tooltipped-' + this.props.position, 'tooltipped', {
            'tooltipped-o': this.props.open
        });

        return React.createElement('div', { className: className, 'aria-label': this.props.title }, this.props.children);
    }
});

module.exports = Tooltip;
module.exports.POSITIONS = POSITIONS;