'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');
var AVATAR_SIZES = SIZES.concat(['button']);

var Avatar = React.createClass({
    displayName: 'Avatar',

    propTypes: {
        src: React.PropTypes.string,
        // No src fallbacks on text
        text: React.PropTypes.string,
        size: React.PropTypes.oneOf(AVATAR_SIZES),
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            src = _props.src,
            size = _props.size,
            className = _props.className,
            text = _props.text,
            children = _props.children;

        className = classNames('avatar', size ? 'avatar-' + size : '', className);

        return React.createElement(
            'figure',
            { className: className, 'data-initial': text },
            src ? React.createElement('img', { src: src }) : null,
            children
        );
    }
});

var AvatarIcon = React.createClass({
    displayName: 'AvatarIcon',

    propTypes: {
        src: React.PropTypes.string,
        className: React.PropTypes.string
    },

    render: function render() {
        var _props2 = this.props,
            src = _props2.src,
            className = _props2.className;

        className = classNames('avatar-icon', className);

        return React.createElement('img', { src: src, className: className });
    }
});

module.exports = Avatar;
module.exports.Icon = AvatarIcon;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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