'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var ReactDOM = require('react-dom');
var classNames = require('classnames');

var Backdrop = require('./Backdrop');
var Dropdown = require('./Dropdown');

var MENU_RIGHT_SPACING = 300;
var MENU_BOTTOM_SPACING = 160;

/**
 * Helper to display a context menu.
 *
 *  <ContextMenu component={() => <ContextMenu.Menu></ContextMenu.Menu>}>
 *    Right click here !
 *  </ContextMenu>
 *
 * @type {ReactClass}
 */
var ContextMenu = React.createClass({
    displayName: 'ContextMenu',

    propTypes: {
        // Delay before opening the menu
        // It should be use when integrating the context menu with a textarea and a selection event
        delay: React.PropTypes.number,
        // Should it prevent the default menu ?
        preventDefault: React.PropTypes.bool,
        // Should it be propaged to parent ?
        stopPropagation: React.PropTypes.bool,
        // Component to render for the menu
        component: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired
    },

    getDefaultProps: function getDefaultProps() {
        return {
            delay: 0,
            preventDefault: true,
            stopPropagation: true
        };
    },
    getInitialState: function getInitialState() {
        return {
            open: false,
            x: 0,
            y: 0,
            directionH: 'e',
            directionV: 's'
        };
    },


    /**
     * When user is opening context menu.
     */
    onOpen: function onOpen(event) {
        var _this = this;

        var _props = this.props,
            delay = _props.delay,
            preventDefault = _props.preventDefault,
            stopPropagation = _props.stopPropagation;


        if (preventDefault) {
            event.preventDefault();
        }
        if (stopPropagation) {
            event.stopPropagation();
        }

        var x = event.clientX;
        var y = event.clientY;

        if (delay) {
            setTimeout(function () {
                return _this.open(x, y);
            }, delay);
        } else {
            this.open(x, y);
        }
    },


    /**
     * Open the menu at position x,y
     */
    open: function open(x, y) {
        var width = window.innerWidth;
        var height = window.innerHeight;

        this.setState({
            open: true,
            x: x,
            y: y,
            directionH: x > width - MENU_RIGHT_SPACING ? 'w' : 'e',
            directionV: y > height - MENU_BOTTOM_SPACING ? 'n' : 's'
        });
    },


    /**
     * When user is closing the menu.
     */
    onClose: function onClose() {
        this.setState({
            open: false
        });
    },


    /**
     * Close the menu after any click on the window.
     * We wait next event loop to avoid hiding the menu before the click got propaged to it.
     */
    onWindowClick: function onWindowClick() {
        var _this2 = this;

        setTimeout(function () {
            return _this2.onClose();
        }, 1);
    },
    bindEvents: function bindEvents() {
        var el = ReactDOM.findDOMNode(this);
        el.addEventListener('contextmenu', this.onOpen, false);
        el.addEventListener('click', this.onWindowClick, false);
    },
    unbindEvents: function unbindEvents() {
        var el = ReactDOM.findDOMNode(this);
        el.removeEventListener('contextmenu', this.onOpen, false);
        el.removeEventListener('click', this.onWindowClick, false);
    },
    componentDidMount: function componentDidMount() {
        this.bindEvents();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.unbindEvents();
    },
    componentWillUpdate: function componentWillUpdate() {
        this.unbindEvents();
    },
    componentDidUpdate: function componentDidUpdate() {
        this.bindEvents();
    },
    render: function render() {
        var _props2 = this.props,
            children = _props2.children,
            component = _props2.component,
            otherProps = _objectWithoutProperties(_props2, ['children', 'component']);

        var _state = this.state,
            open = _state.open,
            x = _state.x,
            y = _state.y,
            directionH = _state.directionH,
            directionV = _state.directionV;


        var inner = React.Children.only(children);

        if (!open) {
            return inner;
        }

        var menu = React.createElement(component, _extends({
            // Pass the current position if we use a specific menu component.
            mouseX: x,
            mouseY: y
        }, otherProps));

        return React.createElement(
            Backdrop,
            { wrapper: inner, onClose: this.onClose },
            React.createElement(
                'div',
                {
                    className: classNames('ContextMenu', 'direction-' + directionH, 'direction-' + directionV),
                    style: { top: y, left: x },
                    onClick: this.onClick },
                menu
            )
        );
    }
});

module.exports = ContextMenu;
module.exports.Divider = Dropdown.Divider;
module.exports.Header = Dropdown.Header;
module.exports.Item = Dropdown.Item;
module.exports.Menu = Dropdown.Menu;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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