'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var Button = require('./Button');

var FileInput = React.createClass({
    displayName: 'FileInput',

    propTypes: {
        children: React.PropTypes.node,
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        accept: React.PropTypes.string,
        disabled: React.PropTypes.bool
    },

    /**
     * Click this button
     */
    click: function click() {
        this.refs.input.click();
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        return React.createElement(
            Button,
            _extends({}, this.props, { onClick: this.click }),
            React.createElement('input', { type: 'file', ref: 'input', name: this.props.name, style: { display: 'none' }, accept: this.props.accept }),
            this.props.children
        );
    }
});

module.exports = FileInput;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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