'use strict';

var React = require('react');
var classNames = require('classnames');

/**
 * Markdown content rendered with clean style.
 *
 * A "convert" prop can be given to convert the markdown to HTML.
 */
var Markdown = React.createClass({
    displayName: 'Markdown',

    propTypes: {
        source: React.PropTypes.string.isRequired,
        className: React.PropTypes.string,
        convert: React.PropTypes.func
    },

    render: function render() {
        var _props = this.props,
            source = _props.source,
            convert = _props.convert,
            className = _props.className;

        var html = convert ? convert(source) : source;
        className = classNames('gb-markdown', className);

        return React.createElement('div', { className: className, dangerouslySetInnerHTML: { __html: html } });
    }
});

module.exports = Markdown;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9NYXJrZG93bi5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJjbGFzc05hbWVzIiwiTWFya2Rvd24iLCJjcmVhdGVDbGFzcyIsInByb3BUeXBlcyIsInNvdXJjZSIsIlByb3BUeXBlcyIsInN0cmluZyIsImlzUmVxdWlyZWQiLCJjbGFzc05hbWUiLCJjb252ZXJ0IiwiZnVuYyIsInJlbmRlciIsInByb3BzIiwiaHRtbCIsIl9faHRtbCIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7O0FBQUEsSUFBTUEsUUFBUUMsUUFBUSxPQUFSLENBQWQ7QUFDQSxJQUFNQyxhQUFhRCxRQUFRLFlBQVIsQ0FBbkI7O0FBRUE7Ozs7O0FBS0EsSUFBTUUsV0FBV0gsTUFBTUksV0FBTixDQUFrQjtBQUFBOztBQUMvQkMsZUFBVztBQUNQQyxnQkFBV04sTUFBTU8sU0FBTixDQUFnQkMsTUFBaEIsQ0FBdUJDLFVBRDNCO0FBRVBDLG1CQUFXVixNQUFNTyxTQUFOLENBQWdCQyxNQUZwQjtBQUdQRyxpQkFBV1gsTUFBTU8sU0FBTixDQUFnQks7QUFIcEIsS0FEb0I7O0FBTy9CQyxVQVArQixvQkFPdEI7QUFBQSxxQkFDZ0MsS0FBS0MsS0FEckM7QUFBQSxZQUNDUixNQURELFVBQ0NBLE1BREQ7QUFBQSxZQUNTSyxPQURULFVBQ1NBLE9BRFQ7QUFBQSxZQUNrQkQsU0FEbEIsVUFDa0JBLFNBRGxCOztBQUVMLFlBQU1LLE9BQU9KLFVBQVVBLFFBQVFMLE1BQVIsQ0FBVixHQUE0QkEsTUFBekM7QUFDQUksb0JBQVlSLFdBQVcsYUFBWCxFQUEwQlEsU0FBMUIsQ0FBWjs7QUFFQSxlQUFPLDZCQUFLLFdBQVdBLFNBQWhCLEVBQTJCLHlCQUF5QixFQUFDTSxRQUFRRCxJQUFULEVBQXBELEdBQVA7QUFDSDtBQWI4QixDQUFsQixDQUFqQjs7QUFnQkFFLE9BQU9DLE9BQVAsR0FBaUJmLFFBQWpCIiwiZmlsZSI6Ik1hcmtkb3duLmpzIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuY29uc3QgY2xhc3NOYW1lcyA9IHJlcXVpcmUoJ2NsYXNzbmFtZXMnKTtcblxuLyoqXG4gKiBNYXJrZG93biBjb250ZW50IHJlbmRlcmVkIHdpdGggY2xlYW4gc3R5bGUuXG4gKlxuICogQSBcImNvbnZlcnRcIiBwcm9wIGNhbiBiZSBnaXZlbiB0byBjb252ZXJ0IHRoZSBtYXJrZG93biB0byBIVE1MLlxuICovXG5jb25zdCBNYXJrZG93biA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICBwcm9wVHlwZXM6IHtcbiAgICAgICAgc291cmNlOiAgICBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICAgIGNsYXNzTmFtZTogUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgY29udmVydDogICBSZWFjdC5Qcm9wVHlwZXMuZnVuY1xuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIGxldCB7IHNvdXJjZSwgY29udmVydCwgY2xhc3NOYW1lIH0gPSB0aGlzLnByb3BzO1xuICAgICAgICBjb25zdCBodG1sID0gY29udmVydCA/IGNvbnZlcnQoc291cmNlKSA6IHNvdXJjZTtcbiAgICAgICAgY2xhc3NOYW1lID0gY2xhc3NOYW1lcygnZ2ItbWFya2Rvd24nLCBjbGFzc05hbWUpO1xuXG4gICAgICAgIHJldHVybiA8ZGl2IGNsYXNzTmFtZT17Y2xhc3NOYW1lfSBkYW5nZXJvdXNseVNldElubmVySFRNTD17e19faHRtbDogaHRtbH19IC8+O1xuICAgIH1cbn0pO1xuXG5tb2R1bGUuZXhwb3J0cyA9IE1hcmtkb3duO1xuIl19