'use strict';

var React = require('react');
var classNames = require('classnames');

/**
 *   <Menu>
 *       <Menu.Item>...</Menu.Item>
 *       <Menu.Item>...</Menu.Item>
 *       <Menu.Item>...</Menu.Item>
 *   </Menu>
 */
var MenuItem = React.createClass({
    displayName: 'MenuItem',

    propTypes: {
        active: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        onClick: React.PropTypes.func,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: null
        };
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            onClick = _props.onClick;

        var className = classNames(this.props.className || '', {
            'active': this.props.active
        });

        return React.createElement(
            'li',
            { className: className },
            React.createElement(
                'a',
                { href: href || '#', onClick: onClick },
                this.props.children
            )
        );
    }
});

var Menu = React.createClass({
    displayName: 'Menu',

    propTypes: {
        right: React.PropTypes.bool,
        left: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: null
        };
    },
    render: function render() {
        var className = classNames('menu', {
            'pull-right': this.props.right,
            'pull-left': this.props.left
        });

        return React.createElement(
            'ul',
            { className: className },
            this.props.children
        );
    }
});

module.exports = Menu;
module.exports.Item = MenuItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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