'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Link = require('./Link');

var POSITIONS = ['top', 'top-right', 'right', 'bottom-right', 'bottom', 'bottom-left', 'left', 'top-left'];

/**
 * Pop content with controls over content:
 *
 * <Popover.Container>
 *   <Button>Open</Button>
 *   {open?
 *      <Popover>
 *         <Popover.Heading title="Hello" />
 *         <Popover.Body>...</Popover.Body>
 *         <Popover.Controls>
 *           <Popover.Control onClick={...}>Say Hello</Popover.Control>
 *           <Popover.Control onClick={...}>Say World</Popover.Control>
 *         </Popover.Controls>
 *      </Popover>
 *   : null}
 * </Popover.Container>
 */

var Popover = React.createClass({
    displayName: 'Popover',

    propTypes: {
        position: React.PropTypes.oneOf(POSITIONS),
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            position: 'bottom'
        };
    },
    render: function render() {
        var position = this.props.position;

        var className = classNames('popover', 'popover-' + position);

        return React.createElement(
            'div',
            { className: 'popover-wrapper' },
            React.createElement(
                'div',
                { className: className },
                React.createElement(
                    PopoverCard,
                    null,
                    React.createElement('div', { className: 'popover-arrow' }),
                    this.props.children
                )
            )
        );
    }
});

var PopoverContainer = React.createClass({
    displayName: 'PopoverContainer',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            className = _props.className,
            props = _objectWithoutProperties(_props, ['className']);

        className = classNames('popover-container', className);

        return React.createElement(
            'div',
            _extends({ className: className }, props),
            this.props.children
        );
    }
});

// The actual element that looks like a popup card.
var PopoverCard = React.createClass({
    displayName: 'PopoverCard',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            _extends({ className: 'popover-card' }, this.props),
            this.props.children
        );
    }
});

var PopoverBody = React.createClass({
    displayName: 'PopoverBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-body' },
            this.props.children
        );
    }
});

var PopoverTitle = React.createClass({
    displayName: 'PopoverTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-title' },
            this.props.children
        );
    }
});

var PopoverHeading = React.createClass({
    displayName: 'PopoverHeading',

    propTypes: {
        title: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props2 = this.props,
            title = _props2.title,
            children = _props2.children;


        if (title) {
            children = React.createElement(
                PopoverTitle,
                null,
                title
            );
        }

        return React.createElement(
            'div',
            { className: 'popover-heading' },
            children
        );
    }
});

var PopoverControl = React.createClass({
    displayName: 'PopoverControl',

    propTypes: {
        children: React.PropTypes.node,
        onClick: React.PropTypes.func,
        active: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            onClick = _props3.onClick,
            children = _props3.children,
            active = _props3.active;

        var className = classNames('control', { active: active });

        return React.createElement(
            Link,
            { className: className, onClick: onClick },
            children
        );
    }
});

var PopoverControls = React.createClass({
    displayName: 'PopoverControls',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-controls' },
            this.props.children
        );
    }
});

module.exports = Popover;
module.exports.Card = PopoverCard;
module.exports.Body = PopoverBody;
module.exports.Heading = PopoverHeading;
module.exports.Title = PopoverTitle;
module.exports.Container = PopoverContainer;
module.exports.Control = PopoverControl;
module.exports.Controls = PopoverControls;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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