'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Button = require('./Button');
var SIZES = require('./SIZES');
var STYLES = require('./STYLES');

/**
 * Displays an inline progress bar.
 *
 * @type {ReactClass}
 */
var ProgressBar = React.createClass({
    displayName: 'ProgressBar',

    propTypes: {
        className: React.PropTypes.string,
        // Progress between 0 and max
        value: React.PropTypes.number,
        max: React.PropTypes.number,
        // Size of the bar
        size: React.PropTypes.oneOf(SIZES),
        style: React.PropTypes.oneOf(STYLES)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            value: 0,
            max: 100,
            size: 'md',
            style: 'success'
        };
    },
    render: function render() {
        var _props = this.props,
            size = _props.size,
            style = _props.style,
            value = _props.value,
            max = _props.max;


        var className = classNames('ProgressBar', 'size-' + size, 'style-' + style, this.props.className);

        var percent = value * 100 / max;

        return React.createElement(
            'div',
            { className: className },
            React.createElement('div', { className: 'bar', style: { width: percent + '%' } })
        );
    }
});

/**
 * Display a progress bar in a button like container.
 * Perfect for insertion in a toolbar.
 *
 * @type {ReactClass}
 */
var ProgressBarButton = React.createClass({
    displayName: 'ProgressBarButton',

    propTypes: {
        size: React.PropTypes.oneOf(SIZES),
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props2 = this.props,
            children = _props2.children,
            className = _props2.className,
            props = _objectWithoutProperties(_props2, ['children', 'className']);

        className = classNames('ProgressBarButton', className);

        return React.createElement(
            Button,
            _extends({ className: className }, props),
            children
        );
    }
});

module.exports = ProgressBar;
module.exports.Button = ProgressBarButton;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9Qcm9ncmVzc0Jhci5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJjbGFzc05hbWVzIiwiQnV0dG9uIiwiU0laRVMiLCJTVFlMRVMiLCJQcm9ncmVzc0JhciIsImNyZWF0ZUNsYXNzIiwicHJvcFR5cGVzIiwiY2xhc3NOYW1lIiwiUHJvcFR5cGVzIiwic3RyaW5nIiwidmFsdWUiLCJudW1iZXIiLCJtYXgiLCJzaXplIiwib25lT2YiLCJzdHlsZSIsImdldERlZmF1bHRQcm9wcyIsInJlbmRlciIsInByb3BzIiwicGVyY2VudCIsIndpZHRoIiwiUHJvZ3Jlc3NCYXJCdXR0b24iLCJjaGlsZHJlbiIsIm5vZGUiLCJtb2R1bGUiLCJleHBvcnRzIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxJQUFNQSxRQUFRQyxRQUFRLE9BQVIsQ0FBZDtBQUNBLElBQU1DLGFBQWFELFFBQVEsWUFBUixDQUFuQjs7QUFFQSxJQUFNRSxTQUFTRixRQUFRLFVBQVIsQ0FBZjtBQUNBLElBQU1HLFFBQVFILFFBQVEsU0FBUixDQUFkO0FBQ0EsSUFBTUksU0FBU0osUUFBUSxVQUFSLENBQWY7O0FBRUE7Ozs7O0FBS0EsSUFBTUssY0FBY04sTUFBTU8sV0FBTixDQUFrQjtBQUFBOztBQUNsQ0MsZUFBVztBQUNQQyxtQkFBV1QsTUFBTVUsU0FBTixDQUFnQkMsTUFEcEI7QUFFUDtBQUNBQyxlQUFXWixNQUFNVSxTQUFOLENBQWdCRyxNQUhwQjtBQUlQQyxhQUFXZCxNQUFNVSxTQUFOLENBQWdCRyxNQUpwQjtBQUtQO0FBQ0FFLGNBQVdmLE1BQU1VLFNBQU4sQ0FBZ0JNLEtBQWhCLENBQXNCWixLQUF0QixDQU5KO0FBT1BhLGVBQVdqQixNQUFNVSxTQUFOLENBQWdCTSxLQUFoQixDQUFzQlgsTUFBdEI7QUFQSixLQUR1Qjs7QUFXbENhLG1CQVhrQyw2QkFXaEI7QUFDZCxlQUFPO0FBQ0hOLG1CQUFPLENBREo7QUFFSEUsaUJBQU8sR0FGSjtBQUdIQyxrQkFBTyxJQUhKO0FBSUhFLG1CQUFPO0FBSkosU0FBUDtBQU1ILEtBbEJpQztBQW9CbENFLFVBcEJrQyxvQkFvQnpCO0FBQUEscUJBQytCLEtBQUtDLEtBRHBDO0FBQUEsWUFDR0wsSUFESCxVQUNHQSxJQURIO0FBQUEsWUFDU0UsS0FEVCxVQUNTQSxLQURUO0FBQUEsWUFDZ0JMLEtBRGhCLFVBQ2dCQSxLQURoQjtBQUFBLFlBQ3VCRSxHQUR2QixVQUN1QkEsR0FEdkI7OztBQUdMLFlBQU1MLFlBQVlQLFdBQ2QsYUFEYyxZQUVOYSxJQUZNLGFBR0xFLEtBSEssRUFJZCxLQUFLRyxLQUFMLENBQVdYLFNBSkcsQ0FBbEI7O0FBT0EsWUFBTVksVUFBV1QsUUFBUSxHQUFULEdBQWdCRSxHQUFoQzs7QUFFQSxlQUNJO0FBQUE7QUFBQSxjQUFLLFdBQVdMLFNBQWhCO0FBQ0kseUNBQUssV0FBVSxLQUFmLEVBQXFCLE9BQU8sRUFBRWEsT0FBVUQsT0FBVixNQUFGLEVBQTVCO0FBREosU0FESjtBQUtIO0FBckNpQyxDQUFsQixDQUFwQjs7QUF3Q0E7Ozs7OztBQU1BLElBQU1FLG9CQUFvQnZCLE1BQU1PLFdBQU4sQ0FBa0I7QUFBQTs7QUFDeENDLGVBQVc7QUFDUE8sY0FBV2YsTUFBTVUsU0FBTixDQUFnQk0sS0FBaEIsQ0FBc0JaLEtBQXRCLENBREo7QUFFUEssbUJBQVdULE1BQU1VLFNBQU4sQ0FBZ0JDLE1BRnBCO0FBR1BhLGtCQUFXeEIsTUFBTVUsU0FBTixDQUFnQmU7QUFIcEIsS0FENkI7O0FBT3hDTixVQVB3QyxvQkFPL0I7QUFBQSxzQkFDbUMsS0FBS0MsS0FEeEM7QUFBQSxZQUNDSSxRQURELFdBQ0NBLFFBREQ7QUFBQSxZQUNXZixTQURYLFdBQ1dBLFNBRFg7QUFBQSxZQUN5QlcsS0FEekI7O0FBR0xYLG9CQUFZUCxXQUNSLG1CQURRLEVBRVJPLFNBRlEsQ0FBWjs7QUFLQSxlQUNJO0FBQUMsa0JBQUQ7QUFBQSx1QkFBUSxXQUFXQSxTQUFuQixJQUFrQ1csS0FBbEM7QUFDS0k7QUFETCxTQURKO0FBS0g7QUFwQnVDLENBQWxCLENBQTFCOztBQXVCQUUsT0FBT0MsT0FBUCxHQUFpQnJCLFdBQWpCO0FBQ0FvQixPQUFPQyxPQUFQLENBQWV4QixNQUFmLEdBQXdCb0IsaUJBQXhCIiwiZmlsZSI6IlByb2dyZXNzQmFyLmpzIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuY29uc3QgY2xhc3NOYW1lcyA9IHJlcXVpcmUoJ2NsYXNzbmFtZXMnKTtcblxuY29uc3QgQnV0dG9uID0gcmVxdWlyZSgnLi9CdXR0b24nKTtcbmNvbnN0IFNJWkVTID0gcmVxdWlyZSgnLi9TSVpFUycpO1xuY29uc3QgU1RZTEVTID0gcmVxdWlyZSgnLi9TVFlMRVMnKTtcblxuLyoqXG4gKiBEaXNwbGF5cyBhbiBpbmxpbmUgcHJvZ3Jlc3MgYmFyLlxuICpcbiAqIEB0eXBlIHtSZWFjdENsYXNzfVxuICovXG5jb25zdCBQcm9ncmVzc0JhciA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICBwcm9wVHlwZXM6IHtcbiAgICAgICAgY2xhc3NOYW1lOiBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICAvLyBQcm9ncmVzcyBiZXR3ZWVuIDAgYW5kIG1heFxuICAgICAgICB2YWx1ZTogICAgIFJlYWN0LlByb3BUeXBlcy5udW1iZXIsXG4gICAgICAgIG1heDogICAgICAgUmVhY3QuUHJvcFR5cGVzLm51bWJlcixcbiAgICAgICAgLy8gU2l6ZSBvZiB0aGUgYmFyXG4gICAgICAgIHNpemU6ICAgICAgUmVhY3QuUHJvcFR5cGVzLm9uZU9mKFNJWkVTKSxcbiAgICAgICAgc3R5bGU6ICAgICBSZWFjdC5Qcm9wVHlwZXMub25lT2YoU1RZTEVTKVxuICAgIH0sXG5cbiAgICBnZXREZWZhdWx0UHJvcHMoKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICB2YWx1ZTogMCxcbiAgICAgICAgICAgIG1heDogICAxMDAsXG4gICAgICAgICAgICBzaXplOiAgJ21kJyxcbiAgICAgICAgICAgIHN0eWxlOiAnc3VjY2VzcydcbiAgICAgICAgfTtcbiAgICB9LFxuXG4gICAgcmVuZGVyKCkge1xuICAgICAgICBjb25zdCB7IHNpemUsIHN0eWxlLCB2YWx1ZSwgbWF4IH0gPSB0aGlzLnByb3BzO1xuXG4gICAgICAgIGNvbnN0IGNsYXNzTmFtZSA9IGNsYXNzTmFtZXMoXG4gICAgICAgICAgICAnUHJvZ3Jlc3NCYXInLFxuICAgICAgICAgICAgYHNpemUtJHtzaXplfWAsXG4gICAgICAgICAgICBgc3R5bGUtJHtzdHlsZX1gLFxuICAgICAgICAgICAgdGhpcy5wcm9wcy5jbGFzc05hbWVcbiAgICAgICAgKTtcblxuICAgICAgICBjb25zdCBwZXJjZW50ID0gKHZhbHVlICogMTAwKSAvIG1heDtcblxuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9e2NsYXNzTmFtZX0+XG4gICAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJiYXJcIiBzdHlsZT17eyB3aWR0aDogYCR7cGVyY2VudH0lYCB9fT48L2Rpdj5cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG4vKipcbiAqIERpc3BsYXkgYSBwcm9ncmVzcyBiYXIgaW4gYSBidXR0b24gbGlrZSBjb250YWluZXIuXG4gKiBQZXJmZWN0IGZvciBpbnNlcnRpb24gaW4gYSB0b29sYmFyLlxuICpcbiAqIEB0eXBlIHtSZWFjdENsYXNzfVxuICovXG5jb25zdCBQcm9ncmVzc0JhckJ1dHRvbiA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICBwcm9wVHlwZXM6IHtcbiAgICAgICAgc2l6ZTogICAgICBSZWFjdC5Qcm9wVHlwZXMub25lT2YoU0laRVMpLFxuICAgICAgICBjbGFzc05hbWU6IFJlYWN0LlByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIGNoaWxkcmVuOiAgUmVhY3QuUHJvcFR5cGVzLm5vZGVcbiAgICB9LFxuXG4gICAgcmVuZGVyKCkge1xuICAgICAgICBsZXQgeyBjaGlsZHJlbiwgY2xhc3NOYW1lLCAuLi5wcm9wcyB9ID0gdGhpcy5wcm9wcztcblxuICAgICAgICBjbGFzc05hbWUgPSBjbGFzc05hbWVzKFxuICAgICAgICAgICAgJ1Byb2dyZXNzQmFyQnV0dG9uJyxcbiAgICAgICAgICAgIGNsYXNzTmFtZVxuICAgICAgICApO1xuXG4gICAgICAgIHJldHVybiAoXG4gICAgICAgICAgICA8QnV0dG9uIGNsYXNzTmFtZT17Y2xhc3NOYW1lfSB7Li4ucHJvcHN9PlxuICAgICAgICAgICAgICAgIHtjaGlsZHJlbn1cbiAgICAgICAgICAgIDwvQnV0dG9uPlxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG5tb2R1bGUuZXhwb3J0cyA9IFByb2dyZXNzQmFyO1xubW9kdWxlLmV4cG9ydHMuQnV0dG9uID0gUHJvZ3Jlc3NCYXJCdXR0b247XG4iXX0=