const React = require('react');
const classNames = require('classnames');

const OCTICONS = [
    'alert',
    'arrow-down',
    'arrow-left',
    'arrow-right',
    'arrow-small-down',
    'arrow-small-left',
    'arrow-small-right',
    'arrow-small-up',
    'arrow-up',
    'beaker',
    'bell',
    'bold',
    'book',
    'bookmark',
    'briefcase',
    'broadcast',
    'browser',
    'bug',
    'calendar',
    'check',
    'checklist',
    'chevron-down',
    'chevron-left',
    'chevron-right',
    'chevron-up',
    'circle-slash',
    'circuit-board',
    'clippy',
    'clock',
    'cloud-download',
    'cloud-upload',
    'code',
    'comment-discussion',
    'comment',
    'credit-card',
    'dash',
    'dashboard',
    'database',
    'desktop-download',
    'device-camera-video',
    'device-camera',
    'device-desktop',
    'device-mobile',
    'diff-added',
    'diff-ignored',
    'diff-modified',
    'diff-removed',
    'diff-renamed',
    'diff',
    'ellipsis',
    'eye',
    'file-binary',
    'file-code',
    'file-directory',
    'file-media',
    'file-pdf',
    'file-submodule',
    'file-symlink-directory',
    'file-symlink-file',
    'file-text',
    'file-zip',
    'flame',
    'fold',
    'gear',
    'gift',
    'gist-secret',
    'gist',
    'git-branch',
    'git-commit',
    'git-compare',
    'git-merge',
    'git-pull-request',
    'globe',
    'graph',
    'heart',
    'history',
    'home',
    'horizontal-rule',
    'hubot',
    'inbox',
    'info',
    'issue-closed',
    'issue-opened',
    'issue-reopened',
    'italic',
    'jersey',
    'key',
    'keyboard',
    'law',
    'light-bulb',
    'link-external',
    'link',
    'list-ordered',
    'list-unordered',
    'location',
    'lock',
    'logo-gist',
    'logo-github',
    'mail-read',
    'mail-reply',
    'mail',
    'mark-github',
    'markdown',
    'megaphone',
    'mention',
    'milestone',
    'mirror',
    'mortar-board',
    'mute',
    'no-newline',
    'octoface',
    'organization',
    'package',
    'paintcan',
    'pencil',
    'person',
    'pin',
    'plug',
    'plus',
    'primitive-dot',
    'primitive-square',
    'pulse',
    'question',
    'quote',
    'radio-tower',
    'repo-clone',
    'repo-force-push',
    'repo-forked',
    'repo-pull',
    'repo-push',
    'repo',
    'rocket',
    'rss',
    'ruby',
    'search',
    'server',
    'settings',
    'shield',
    'sign-in',
    'sign-out',
    'smiley',
    'squirrel',
    'star',
    'stop',
    'sync',
    'tag',
    'tasklist',
    'telescope',
    'terminal',
    'text-size',
    'three-bars',
    'thumbsdown',
    'thumbsup',
    'tools',
    'trashcan',
    'triangle-down',
    'triangle-left',
    'triangle-right',
    'triangle-up',
    'unfold',
    'unmute',
    'verified',
    'versions',
    'watch',
    'x',
    'zap'
];

/**
 * Render an icon from octicon or font-awesome
 * @type {ReactClass}
 */
const Icon = React.createClass({
    statics: {
        OCTICONS
    },

    propTypes: {
        // Icon of the icon in the collection
        id:        React.PropTypes.string,
        // Type of collection
        type:      React.PropTypes.string,
        // Extra className
        className: React.PropTypes.string,
        // Is the icon spinning?
        spin:      React.PropTypes.bool
    },

    getDefaultProps() {
        return {
            type: 'octicon',
            spin: false
        };
    },

    render() {
        let { type, id, className, spin } = this.props;

        className = classNames(
            'Icon',
            type + ' ' + type + '-' + id,
            className,
            {
                'icon-spin': spin
            }
        );

        return <i className={className}></i>;
    }
});

module.exports = Icon;
