'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Blankslate = require('../src/Blankslate');

var SCOPE = { React: React, Blankslate: Blankslate };

var EXAMPLE_DEFAULT = '<Blankslate icon="book">\n    <h3>No books</h3>\n    <p>Create a book to get started</p>\n</Blankslate>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Blankslates', active: 'blankslates' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Blankslate' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Blankslates are for when there is a lack of content within a page or section.',
                    ' ',
                    'Use them as placeholders to tell users why something isn\u2019t there. Be sure to provide an action to add content as well.'
                ),
                React.createElement(CodeEditor, { source: 'const Blankslate = require(\'gitbook-styleguide/lib/Blankslate\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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