'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Button = require('../src/Button');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Button: Button, Icon: Icon };

var EXAMPLE_DEFAULT = '<Button.Toolbar>\n    <Button>Button button</Button>\n    <Button href="#">Link button</Button>\n</Button.Toolbar>';

var EXAMPLE_SIZES = '<Button.Toolbar>\n    <Button size="lg">Large button</Button>\n    <Button size="md">Normal button</Button>\n    <Button size="sm">Small button</Button>\n    <Button size="xs">Extra small button</Button>\n</Button.Toolbar>';

var EXAMPLE_STYLES = '<Button.Toolbar>\n    <Button style="primary">Primary</Button>\n    <Button style="success">Success</Button>\n    <Button style="danger">Danger</Button>\n    <Button style="secondary">Secondary</Button>\n    <Button style="link">Link</Button>\n    <Button style="marketing-primary">Marketing</Button>\n</Button.Toolbar>';

var EXAMPLE_STYLE_COUNT = '<Button.Group>\n    <Button onClick={event => this.setState({ count: this.state.count + 1 })}>\n        <Icon id="star" /> Star\n    </Button>\n    <Button href="#" style="count">{this.state.count}</Button>\n</Button.Group>';

var EXAMPLE_STATES = '<Button.Toolbar>\n    <Button>Default</Button>\n    <Button active>Active</Button>\n    <Button disabled>Disabled</Button>\n\n    <Button style="primary">Default</Button>\n    <Button style="primary" active>Active</Button>\n    <Button style="primary" disabled>Disabled</Button>\n</Button.Toolbar>';

var EXAMPLE_LABELS = '<Button.Toolbar>\n    <Button title="Label">Default</Button>\n    <Button title="Label" active>Active</Button>\n    <Button title="Label" disabled>Disabled</Button>\n</Button.Toolbar>';

var EXAMPLE_BLOCK = '<Button block style="primary">Primary block button</Button>\n<Button block>Secondary button</Button>';

var EXAMPLE_GROUP = '<Button.Toolbar>\n    <Button.Group>\n        <Button>Button</Button>\n        <Button>Button</Button>\n    </Button.Group>\n    <Button.Group>\n        <Button size="sm">Button</Button>\n        <Button size="sm">Button</Button>\n    </Button.Group>\n</Button.Toolbar>';

var EXAMPLE_GROUP_JUSTIFIED = '<Button.Group block>\n    <Button>Button</Button>\n    <Button>Button</Button>\n</Button.Group>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Buttons', active: 'buttons' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Buttons' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Buttons are used for actions, like in forms, while textual hyperlinks are used for destinations, or moving from one page to another.'
                ),
                React.createElement(CodeEditor, { source: 'const Button = require(\'gitbook-styleguide/lib/Button\');' })
            )
        ),
        React.createElement(Example, { title: 'Default buttons', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Sizes', source: EXAMPLE_SIZES, scope: SCOPE },
            'Buttons are availables in multiples sizes: Large, Normal, Small and Extra-Small.'
        ),
        React.createElement(
            Example,
            { title: 'Styles', source: EXAMPLE_STYLES, scope: SCOPE },
            'Buttons can be filled to indicate a more important action:'
        ),
        React.createElement(
            Example,
            { title: 'Counts', source: EXAMPLE_STYLE_COUNT, scope: SCOPE, state: { count: 0 } },
            'Buttons with a count.'
        ),
        React.createElement(
            Example,
            { title: 'States', source: EXAMPLE_STATES, scope: SCOPE },
            'Buttons can have different states:'
        ),
        React.createElement(
            Example,
            { title: 'Labels', source: EXAMPLE_LABELS, scope: SCOPE },
            'Buttons can have a label on hover:'
        ),
        React.createElement(
            Example,
            { title: 'Block buttons', source: EXAMPLE_BLOCK, scope: SCOPE },
            'Create block level buttons\u2014those that span the full width of a parent:'
        ),
        React.createElement(
            Example,
            { title: 'Button groups', source: EXAMPLE_GROUP, scope: SCOPE },
            'Have a hankering for a series of buttons that are attached to one another? Wrap them in a `Button.Group` and the buttons will be rounded and spaced automatically.'
        ),
        React.createElement(
            Example,
            { title: 'Justified Button groups', source: EXAMPLE_GROUP_JUSTIFIED, scope: SCOPE },
            'Button groups can be justified, to make a group of buttons stretch at equal sizes to span the entire width of its parent. Also works with button dropdowns within the button group.'
        )
    );
};
//# sourceMappingURL=data:application/json;base64,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