'use strict';

var React = require('react');

var _require = require('babel-standalone'),
    transform = _require.transform;

var Alert = require('../../src/Alert');
var Panel = require('../../src/Panel');
var CodeEditor = require('./CodeEditor');

var STYLE_PRE_ERROR = {
    padding: 0,
    background: 'none',
    color: 'inherit',
    border: 'none',
    margin: 0
};

function evalCode(code, scope) {
    var initialState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    // Wrap in a function
    code = '(React.createClass({\n    getInitialState() {\n        return ' + JSON.stringify(initialState) + ';\n    },\n\n    render() {\n        const {' + Object.keys(scope).join(',') + '} = this.props;\n        return <div>' + code + '</div>\n    }\n}))';

    // Compile with babel
    code = transform(code, { presets: ['es2015', 'react', 'stage-1'] }).code;

    var Component = eval(code);
    return React.createElement(Component, scope);
}

var Example = React.createClass({
    displayName: 'Example',

    propTypes: {
        title: React.PropTypes.string,
        source: React.PropTypes.string,
        children: React.PropTypes.node,
        scope: React.PropTypes.object,
        state: React.PropTypes.object
    },

    getDefaultProps: function getDefaultProps() {
        return {
            scope: {}
        };
    },


    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        return { source: source };
    },


    // Editor has been modified
    onChange: function onChange(source) {
        this.setState({ source: source });
    },
    render: function render() {
        var _props = this.props,
            title = _props.title,
            children = _props.children,
            scope = _props.scope,
            state = _props.state;
        var source = this.state.source;


        var result = void 0;
        try {
            result = evalCode(source, scope, state);
        } catch (error) {
            result = React.createElement(
                Alert.Danger,
                null,
                React.createElement(
                    'pre',
                    { style: STYLE_PRE_ERROR },
                    error.message
                )
            );
        }

        return React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: title }),
            children ? React.createElement(
                Panel.Body,
                null,
                children
            ) : null,
            React.createElement(
                Panel.Body,
                null,
                result
            ),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: source, onChange: this.onChange })
            )
        );
    }
});

module.exports = Example;
//# sourceMappingURL=data:application/json;base64,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