'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Dropdown = require('../src/Dropdown');
var Button = require('../src/Button');
var ContextMenu = require('../src/ContextMenu');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Dropdown: Dropdown, Button: Button, Icon: Icon, ContextMenu: ContextMenu };

var EXAMPLE_IMPORT = 'const Dropdown = require(\'gitbook-styleguide/lib/Dropdown\')';
var EXAMPLE_DEFAULT = '<Dropdown>\n    <Button>\n        Toggle dropdown <Button.Caret />\n    </Button>\n    <Dropdown.Header>Account</Dropdown.Header>\n    <Dropdown.Item href="/profile">Profile</Dropdown.Item>\n    <Dropdown.Item href="/settings">Settings</Dropdown.Item>\n    <Dropdown.Divider />\n    <Dropdown.Item onClick={e => alert(\'Logout\')}>Logout</Dropdown.Item>\n</Dropdown>';

var EXAMPLE_CONTEXTMENU = '<ContextMenu component={() => (\n    <Dropdown.Menu>\n        <Dropdown.Header>Account</Dropdown.Header>\n        <Dropdown.Item href="/profile">Profile</Dropdown.Item>\n        <Dropdown.Item href="/settings">Settings</Dropdown.Item>\n        <Dropdown.Divider />\n        <Dropdown.Item onClick={e => alert(\'Logout\')}>Logout</Dropdown.Item>\n    </Dropdown.Menu>\n)}>\n    <div>Left click</div>\n</ContextMenu>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Dropdowns', active: 'dropdowns' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Dropdowns' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Context Menu', source: EXAMPLE_CONTEXTMENU, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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