'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Form = require('../src/Form');
var Icon = require('../src/Icon');
var Input = require('../src/Input');
var Button = require('../src/Button');
var Select = require('../src/Select');
var Checkbox = require('../src/Checkbox');
var Textarea = require('../src/Textarea');

var SCOPE = { React: React, Form: Form, Input: Input, Icon: Icon, Button: Button, Select: Select, Checkbox: Checkbox, Textarea: Textarea };

var EXAMPLE_IMPORT = 'const Form = require(\'gitbook-styleguide/lib/Form\');\nconst Input = require(\'gitbook-styleguide/lib/Input\');';

var EXAMPLE_DEFAULT = '<Form>\n    <Form.Group>\n        <label>Name</label>\n        <Input name="name" placeholder="John" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" placeholder="john@doe.com" />\n    </Form.Group>\n    <Form.Group>\n        <label>Message</label>\n        <Textarea placeholder="Some message" />\n    </Form.Group>\n    <Form.Actions>\n        <Button type="submit" style="primary">Submit</Button>\n        <Button type="cancel" style="secondary">Cancel</Button>\n    </Form.Actions>\n</Form>';

var EXAMPLE_SIZES = '<Input size="lg" placeholder="Large input" />\n<Input size="md" placeholder="Normal input" />\n<Input size="sm" placeholder="Small input" />\n<Input size="xs" placeholder="Extra small input" />';

var EXAMPLE_SELECT = '<Select\n    name="language"\n    search={false}\n    options={[\n        \'French\',\n        \'English\'\n    ]}\n/>';

var EXAMPLE_STATES = '<Form>\n    <Form.Group error>\n        <label>Name</label>\n        <Input name="name" placeholder="This field has an error" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" disabled placeholder="This field is disabled" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" focus placeholder="This field is focus" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" readOnly placeholder="This field is read only" />\n    </Form.Group>\n</Form>';

var EXAMPLE_CHECKBOX = '<Form>\n    <Checkbox name="something" checked>\n        Something to check (with control state)\n    </Checkbox>\n    <Checkbox name="something" size="lg">\n        Something to check (Large)\n    </Checkbox>\n    <Checkbox name="something" direction="right">\n        Something to check (On the right)\n    </Checkbox>\n</Form>';

var EXAMPLE_INPUTGROUP = '<Form>\n    <Form.Group>\n        <label>Email address</label>\n        <Input.Group>\n            <Input.GroupAddon>\n                @\n            </Input.GroupAddon>\n            <Input name="email" placeholder="Enter an email" />\n        </Input.Group>\n    </Form.Group>\n</Form>';

var EXAMPLE_SELECT_COMPLEX = '<Select\n    name="countries"\n    filter={(query, option) => option.label.indexOf(query) >= 0}\n    component={({option}) => <span>{option.label}</span>}\n    options={[\n        { id: \'US\', label: \'United States\' },\n        { id: \'FR\', label: \'France\' },\n        { id: \'UK\', label: \'United Kingdom\' }\n    ]}\n/>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Forms and Inputs', active: 'forms' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Forms and Inputs' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'These components are the basic building blocks for creating forms.',
                    ' ',
                    'Each of these elements can be used individually throughout the site,',
                    ' ',
                    'however it\'s recommended to use the field components when building forms',
                    ' ',
                    'in order to take advantage of their accessibility and responsive features.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Layout', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Sizing', source: EXAMPLE_SIZES, scope: SCOPE },
            'Make inputs smaller, larger, or full-width with an additional property.'
        ),
        React.createElement(
            Example,
            { title: 'States', source: EXAMPLE_STATES, scope: SCOPE },
            'States can be used to signal an error on a field.'
        ),
        React.createElement(Example, { title: 'Checkbox', source: EXAMPLE_CHECKBOX, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Input Groups', source: EXAMPLE_INPUTGROUP, scope: SCOPE },
            'Extend form controls by adding text or buttons before, after, or on both sides of any text-based input.'
        ),
        React.createElement(
            Example,
            { title: 'Select', source: EXAMPLE_SELECT, scope: SCOPE },
            'HTML select are replaced by an input allowing more options (search, multiple values, custom renderers with icons, etc).'
        ),
        React.createElement(
            Example,
            { title: 'Complex Select', source: EXAMPLE_SELECT_COMPLEX, scope: SCOPE },
            React.createElement(
                'code',
                null,
                'Select'
            ),
            ' has different properties for customizing the rendering and the behaviour.'
        )
    );
};
//# sourceMappingURL=data:application/json;base64,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