'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Page = require('./components/Page');
var Panel = require('../src/Panel');
var CodeEditor = require('./components/CodeEditor');

exports.default = function () {
    return _react2.default.createElement(
        Page,
        { title: 'About', active: 'introduction' },
        _react2.default.createElement(
            Panel,
            null,
            _react2.default.createElement(Panel.Heading, { title: 'About this styleguide' }),
            _react2.default.createElement(
                Panel.Body,
                null,
                _react2.default.createElement(
                    'p',
                    null,
                    'GitBook Styleguide is a collection of styling, React components and rules;',
                    ' ',
                    'which are being used by the GitBook team on our applications such as gitbook.com.'
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    'This styleguide is open to criticsms and feedback, feel free to ',
                    _react2.default.createElement(
                        'a',
                        { href: 'https://github.com/GitbookIO/styleguide' },
                        'post an issue on GitHub'
                    ),
                    '.'
                )
            )
        ),
        _react2.default.createElement(
            Panel,
            null,
            _react2.default.createElement(Panel.Heading, { title: 'Installation' }),
            _react2.default.createElement(
                Panel.Body,
                null,
                _react2.default.createElement(
                    'p',
                    null,
                    'GitBook styleguide can be installed using ',
                    _react2.default.createElement(
                        'b',
                        null,
                        'NPM'
                    ),
                    ',',
                    ' ',
                    'the module is published as ',
                    _react2.default.createElement(
                        'code',
                        null,
                        'gitbook-styleguide'
                    ),
                    '.'
                ),
                _react2.default.createElement(CodeEditor, { source: '$ npm install gitbook-styleguide --save-dev' })
            )
        ),
        _react2.default.createElement(
            Panel,
            null,
            _react2.default.createElement(Panel.Heading, { title: 'Open Source' }),
            _react2.default.createElement(
                Panel.Body,
                null,
                _react2.default.createElement(
                    'p',
                    null,
                    'Available for use under the ',
                    _react2.default.createElement(
                        'b',
                        null,
                        'Apache 2.0'
                    ),
                    ' license and built with open source projects like React, LESS and more.'
                )
            )
        )
    );
};
//# sourceMappingURL=data:application/json;base64,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