'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Link = require('../src/Link');

var SCOPE = { React: React, Link: Link };

var EXAMPLE_DEFAULT = '\n<ul>\n    <li>\n        <Link href="https://www.gitbook.com" target="_blank">Normal link</Link>\n    </li>\n    <li>\n        <Link muted={true}>Muted link</Link>\n    </li>\n\n    <li>\n        <Link underlined={true}>Underlined link</Link>\n    </li>\n\n    <li>\n        <Link onClick={() => window.alert(\'onClick\')}>onClick link</Link>\n    </li>\n</ul>\n';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Links', active: 'links' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Links' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Some links'
                ),
                React.createElement(CodeEditor, { source: 'const Link = require(\'gitbook-styleguide/lib/Link\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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