'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Modal = require('../src/Modal');
var Button = require('../src/Button');
var Backdrop = require('../src/Backdrop');

var SCOPE = { React: React, Modal: Modal, Button: Button, Backdrop: Backdrop };

var EXAMPLE_IMPORT = 'const Modal = require(\'gitbook-styleguide/lib/Modal\');';

var EXAMPLE_DEFAULT = '<Modal animated={false}>\n    <Modal.Heading title="Title" />\n    <Modal.Body>\n        Body of the modal\n    </Modal.Body>\n    <Modal.Footer>\n        <Button style="secondary">Cancel</Button>\n        <Button style="primary">Important action</Button>\n    </Modal.Footer>\n</Modal>';

var EXAMPLE_BACKDROP = '\n<Button onClick={event => this.setState({ open: true })}>Open modal</Button>\n{this.state.open ?\n    <Backdrop wrapper={<Modal.Backdrop />} onClose={event => this.setState({ open: false })}>\n        <Modal>\n            <Modal.Heading title="Title" />\n            <Modal.Body>\n                Body of the modal\n            </Modal.Body>\n            <Modal.Footer>\n                <Button style="secondary" onClick={event => this.setState({ open: false })}>Cancel</Button>\n                <Button style="primary">Important action</Button>\n            </Modal.Footer>\n        </Modal>\n    </Backdrop>\n: null}';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Modals', active: 'modals' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Modals' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Modals are streamlined, but flexible, dialog prompts with the minimum required functionality and smart defaults.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With a backdrop', source: EXAMPLE_BACKDROP, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBhZ2VzL21vZGFscy5qcz9lbnRyeSJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJQYWdlIiwiRXhhbXBsZSIsIkNvZGVFZGl0b3IiLCJQYW5lbCIsIk1vZGFsIiwiQnV0dG9uIiwiQmFja2Ryb3AiLCJTQ09QRSIsIkVYQU1QTEVfSU1QT1JUIiwiRVhBTVBMRV9ERUZBVUxUIiwiRVhBTVBMRV9CQUNLRFJPUCJdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxJQUFNQSxRQUFRQyxRQUFRLE9BQVIsQ0FBZDs7QUFFQSxJQUFNQyxPQUFPRCxRQUFRLG1CQUFSLENBQWI7QUFDQSxJQUFNRSxVQUFVRixRQUFRLHNCQUFSLENBQWhCO0FBQ0EsSUFBTUcsYUFBYUgsUUFBUSx5QkFBUixDQUFuQjs7QUFFQSxJQUFNSSxRQUFRSixRQUFRLGNBQVIsQ0FBZDtBQUNBLElBQU1LLFFBQVFMLFFBQVEsY0FBUixDQUFkO0FBQ0EsSUFBTU0sU0FBU04sUUFBUSxlQUFSLENBQWY7QUFDQSxJQUFNTyxXQUFXUCxRQUFRLGlCQUFSLENBQWpCOztBQUVBLElBQU1RLFFBQVEsRUFBRVQsWUFBRixFQUFTTSxZQUFULEVBQWdCQyxjQUFoQixFQUF3QkMsa0JBQXhCLEVBQWQ7O0FBRUEsSUFBTUUsaUJBQ04sMERBREE7O0FBR0EsSUFBTUMsa1RBQU47O0FBWUEsSUFBTUMsaW9CQUFOOztrQkFrQmUsWUFBTTtBQUNqQixXQUNJO0FBQUMsWUFBRDtBQUFBLFVBQU0sT0FBTSxRQUFaLEVBQXFCLFFBQU8sUUFBNUI7QUFDSTtBQUFDLGlCQUFEO0FBQUE7QUFDSSxnQ0FBQyxLQUFELENBQU8sT0FBUCxJQUFlLE9BQU0sUUFBckIsR0FESjtBQUVJO0FBQUMscUJBQUQsQ0FBTyxJQUFQO0FBQUE7QUFDSTtBQUFBO0FBQUE7QUFBQTtBQUFBLGlCQURKO0FBRUksb0NBQUMsVUFBRCxJQUFZLFFBQVFGLGNBQXBCO0FBRko7QUFGSixTQURKO0FBU0ksNEJBQUMsT0FBRCxJQUFTLE9BQU0sU0FBZixFQUF5QixRQUFRQyxlQUFqQyxFQUFrRCxPQUFPRixLQUF6RCxHQVRKO0FBVUksNEJBQUMsT0FBRCxJQUFTLE9BQU0saUJBQWYsRUFBaUMsUUFBUUcsZ0JBQXpDLEVBQTJELE9BQU9ILEtBQWxFO0FBVkosS0FESjtBQWNILEMiLCJmaWxlIjoibW9kYWxzLmpzP2VudHJ5Iiwic291cmNlUm9vdCI6Ii9Vc2Vycy9qcHJleW5hdC9HaXRCb29rL3N0eWxlZ3VpZGUiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBSZWFjdCA9IHJlcXVpcmUoJ3JlYWN0Jyk7XG5cbmNvbnN0IFBhZ2UgPSByZXF1aXJlKCcuL2NvbXBvbmVudHMvUGFnZScpO1xuY29uc3QgRXhhbXBsZSA9IHJlcXVpcmUoJy4vY29tcG9uZW50cy9FeGFtcGxlJyk7XG5jb25zdCBDb2RlRWRpdG9yID0gcmVxdWlyZSgnLi9jb21wb25lbnRzL0NvZGVFZGl0b3InKTtcblxuY29uc3QgUGFuZWwgPSByZXF1aXJlKCcuLi9zcmMvUGFuZWwnKTtcbmNvbnN0IE1vZGFsID0gcmVxdWlyZSgnLi4vc3JjL01vZGFsJyk7XG5jb25zdCBCdXR0b24gPSByZXF1aXJlKCcuLi9zcmMvQnV0dG9uJyk7XG5jb25zdCBCYWNrZHJvcCA9IHJlcXVpcmUoJy4uL3NyYy9CYWNrZHJvcCcpO1xuXG5jb25zdCBTQ09QRSA9IHsgUmVhY3QsIE1vZGFsLCBCdXR0b24sIEJhY2tkcm9wIH07XG5cbmNvbnN0IEVYQU1QTEVfSU1QT1JUID1cbidjb25zdCBNb2RhbCA9IHJlcXVpcmUoXFwnZ2l0Ym9vay1zdHlsZWd1aWRlL2xpYi9Nb2RhbFxcJyk7JztcblxuY29uc3QgRVhBTVBMRV9ERUZBVUxUID1cbmA8TW9kYWwgYW5pbWF0ZWQ9e2ZhbHNlfT5cbiAgICA8TW9kYWwuSGVhZGluZyB0aXRsZT1cIlRpdGxlXCIgLz5cbiAgICA8TW9kYWwuQm9keT5cbiAgICAgICAgQm9keSBvZiB0aGUgbW9kYWxcbiAgICA8L01vZGFsLkJvZHk+XG4gICAgPE1vZGFsLkZvb3Rlcj5cbiAgICAgICAgPEJ1dHRvbiBzdHlsZT1cInNlY29uZGFyeVwiPkNhbmNlbDwvQnV0dG9uPlxuICAgICAgICA8QnV0dG9uIHN0eWxlPVwicHJpbWFyeVwiPkltcG9ydGFudCBhY3Rpb248L0J1dHRvbj5cbiAgICA8L01vZGFsLkZvb3Rlcj5cbjwvTW9kYWw+YDtcblxuY29uc3QgRVhBTVBMRV9CQUNLRFJPUCA9XG5gXG48QnV0dG9uIG9uQ2xpY2s9e2V2ZW50ID0+IHRoaXMuc2V0U3RhdGUoeyBvcGVuOiB0cnVlIH0pfT5PcGVuIG1vZGFsPC9CdXR0b24+XG57dGhpcy5zdGF0ZS5vcGVuID9cbiAgICA8QmFja2Ryb3Agd3JhcHBlcj17PE1vZGFsLkJhY2tkcm9wIC8+fSBvbkNsb3NlPXtldmVudCA9PiB0aGlzLnNldFN0YXRlKHsgb3BlbjogZmFsc2UgfSl9PlxuICAgICAgICA8TW9kYWw+XG4gICAgICAgICAgICA8TW9kYWwuSGVhZGluZyB0aXRsZT1cIlRpdGxlXCIgLz5cbiAgICAgICAgICAgIDxNb2RhbC5Cb2R5PlxuICAgICAgICAgICAgICAgIEJvZHkgb2YgdGhlIG1vZGFsXG4gICAgICAgICAgICA8L01vZGFsLkJvZHk+XG4gICAgICAgICAgICA8TW9kYWwuRm9vdGVyPlxuICAgICAgICAgICAgICAgIDxCdXR0b24gc3R5bGU9XCJzZWNvbmRhcnlcIiBvbkNsaWNrPXtldmVudCA9PiB0aGlzLnNldFN0YXRlKHsgb3BlbjogZmFsc2UgfSl9PkNhbmNlbDwvQnV0dG9uPlxuICAgICAgICAgICAgICAgIDxCdXR0b24gc3R5bGU9XCJwcmltYXJ5XCI+SW1wb3J0YW50IGFjdGlvbjwvQnV0dG9uPlxuICAgICAgICAgICAgPC9Nb2RhbC5Gb290ZXI+XG4gICAgICAgIDwvTW9kYWw+XG4gICAgPC9CYWNrZHJvcD5cbjogbnVsbH1gO1xuXG5leHBvcnQgZGVmYXVsdCAoKSA9PiB7XG4gICAgcmV0dXJuIChcbiAgICAgICAgPFBhZ2UgdGl0bGU9XCJNb2RhbHNcIiBhY3RpdmU9XCJtb2RhbHNcIj5cbiAgICAgICAgICAgIDxQYW5lbD5cbiAgICAgICAgICAgICAgICA8UGFuZWwuSGVhZGluZyB0aXRsZT1cIk1vZGFsc1wiIC8+XG4gICAgICAgICAgICAgICAgPFBhbmVsLkJvZHk+XG4gICAgICAgICAgICAgICAgICAgIDxwPk1vZGFscyBhcmUgc3RyZWFtbGluZWQsIGJ1dCBmbGV4aWJsZSwgZGlhbG9nIHByb21wdHMgd2l0aCB0aGUgbWluaW11bSByZXF1aXJlZCBmdW5jdGlvbmFsaXR5IGFuZCBzbWFydCBkZWZhdWx0cy48L3A+XG4gICAgICAgICAgICAgICAgICAgIDxDb2RlRWRpdG9yIHNvdXJjZT17RVhBTVBMRV9JTVBPUlR9IC8+XG4gICAgICAgICAgICAgICAgPC9QYW5lbC5Cb2R5PlxuICAgICAgICAgICAgPC9QYW5lbD5cblxuICAgICAgICAgICAgPEV4YW1wbGUgdGl0bGU9XCJFeGFtcGxlXCIgc291cmNlPXtFWEFNUExFX0RFRkFVTFR9IHNjb3BlPXtTQ09QRX0+PC9FeGFtcGxlPlxuICAgICAgICAgICAgPEV4YW1wbGUgdGl0bGU9XCJXaXRoIGEgYmFja2Ryb3BcIiBzb3VyY2U9e0VYQU1QTEVfQkFDS0RST1B9IHNjb3BlPXtTQ09QRX0+PC9FeGFtcGxlPlxuICAgICAgICA8L1BhZ2U+XG4gICAgKTtcbn07XG4iXX0=