'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var FilterList = require('../src/FilterList');
var Icon = require('../src/Icon');
var ListGroup = require('../src/ListGroup');
var Overview = require('../src/Overview');
var Pagination = require('../src/Pagination');
var PageHead = require('../src/PageHead');
var Menu = require('../src/Menu');
var SearchBar = require('../src/SearchBar');
var Row = require('../src/Row');
var Container = require('../src/Container');

var SCOPE = { React: React, FilterList: FilterList, Panel: Panel, ListGroup: ListGroup, Icon: Icon, Overview: Overview,
    Pagination: Pagination, PageHead: PageHead, Menu: Menu, SearchBar: SearchBar, Row: Row, Container: Container };

var EXAMPLE_IMPORTS = 'const FilterList = require(\'gitbook-styleguide/lib/FilterList\');\nconst Menu = require(\'gitbook-styleguide/lib/Menu\');\nconst SearchBar = require(\'gitbook-styleguide/lib/SearchBar\');\nconst PageHead = require(\'gitbook-styleguide/lib/PageHead\');\nconst Pagination = require(\'gitbook-styleguide/lib/Pagination\');\nconst ListGroup = require(\'gitbook-styleguide/lib/ListGroup\');\nconst Overview = require(\'gitbook-styleguide/lib/Overview\');';

var EXAMPLE_MENU = '<Panel>\n    <ListGroup>\n        <ListGroup.Item active={true}>\n            <Icon id="gear" size="sm" /> Account\n        </ListGroup.Item>\n        <ListGroup.Item>\n            <Icon id="person" size="sm" /> Profile\n        </ListGroup.Item>\n        <ListGroup.Item>\n            <Icon id="mail" size="sm" /> Notifications\n        </ListGroup.Item>\n    </ListGroup>\n</Panel>';

var EXAMPLE_PAGEHEAD_MENU = '<PageHead>\n    <Container>\n        <Row>\n            <Row.Col md={5}>\n                <PageHead.Title>\n                    Contact GitBook\n                </PageHead.Title>\n            </Row.Col>\n            <Row.Col md={7}>\n                <Menu right>\n                    <Menu.Item>About</Menu.Item>\n                    <Menu.Item active>Contact</Menu.Item>\n                    <Menu.Item>Terms of Service</Menu.Item>\n                </Menu>\n            </Row.Col>\n        </Row>\n    </Container>\n</PageHead>';

var EXAMPLE_PAGEHEAD_OVERVIEW = '<PageHead>\n    <Container>\n        <Overview>\n            <Overview.Title>\n                <Overview.StepTitle href="/">\n                    myorg\n                </Overview.StepTitle>\n                <Overview.StepDivider />\n                <Overview.StepTitle primary>\n                    My Book\n                </Overview.StepTitle>\n            </Overview.Title>\n            <Overview.Note>\n                Updated 2 days ago\n            </Overview.Note>\n        </Overview>\n    </Container>\n    <Container>\n        <Menu left>\n            <Menu.Item>Overview</Menu.Item>\n            <Menu.Item active>Metrics</Menu.Item>\n            <Menu.Item>Settings</Menu.Item>\n        </Menu>\n    </Container>\n</PageHead>';

var EXAMPLE_PAGEHEAD_SEARCH = '<PageHead>\n    <Container>\n        <Row>\n            <Row.Col md={8}>\n                <PageHead.Title>\n                    <Icon id="star" size="sm" /> Explore GitBook\n                </PageHead.Title>\n            </Row.Col>\n            <Row.Col md={4}>\n                <SearchBar placeholder="Search books" />\n            </Row.Col>\n        </Row>\n    </Container>\n</PageHead>';

var EXAMPLE_FILTERLIST = '<FilterList>\n    <FilterList.Item selected={true} count={21}>First filter</FilterList.Item>\n    <FilterList.Item count={3}>Second filter</FilterList.Item>\n    <FilterList.Item>Third filter</FilterList.Item>\n</FilterList>';

var EXAMPLE_PAGINATION = '<Pagination page={4} pages={20} pagesToList={3} />';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Navigation', active: 'navigation' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Navigation' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'This styleguide comes with several navigation components. Some were designed with singular purposes, while others were design to be more flexible and appear quite frequently.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORTS })
            )
        ),
        React.createElement(Example, { title: 'Page head with menu', source: EXAMPLE_PAGEHEAD_MENU, scope: SCOPE }),
        React.createElement(Example, { title: 'Page head with search bar', source: EXAMPLE_PAGEHEAD_SEARCH, scope: SCOPE }),
        React.createElement(Example, { title: 'Page head with overview', source: EXAMPLE_PAGEHEAD_OVERVIEW, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Menu', source: EXAMPLE_MENU, scope: SCOPE },
            'The menu is a vertical list of navigational links. It should be put in a panel.'
        ),
        React.createElement(
            Example,
            { title: 'Filter list', source: EXAMPLE_FILTERLIST, scope: SCOPE },
            'A vertical list of filters. Grey text on white background. Selecting a filter from the list will fill its background with blue and make the text white.'
        ),
        React.createElement(Example, { title: 'Pagination', source: EXAMPLE_PAGINATION, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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