'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Popover = require('../src/Popover');
var Input = require('../src/Input');
var Icon = require('../src/Icon');
var Button = require('../src/Button');

var SCOPE = { React: React, Panel: Panel, Popover: Popover, Button: Button, Input: Input, Icon: Icon };

var EXAMPLE_IMPORT = 'const Popover = require(\'gitbook-styleguide/lib/Popover\');';

var EXAMPLE_DEFAULT = '<Popover>\n    <Popover.Heading title="Hello" />\n    <Popover.Body>\n        Inner body of the popover.\n    </Popover.Body>\n    <Popover.Controls>\n        <Popover.Control active onClick={event => alert(\'Hello\')}>\n            Say Hello\n        </Popover.Control>\n        <Popover.Control onClick={event => alert(\'World\')}>\n            Say World\n        </Popover.Control>\n    </Popover.Controls>\n</Popover>';

var EXAMPLE_WITH_INPUT = '<Popover>\n    <Popover.Heading>\n        <Popover.Title>\n            <Icon id="pencil" /> Edit title\n        </Popover.Title>\n    </Popover.Heading>\n    <Popover.Body>\n        <Input placeholder="Some title" />\n    </Popover.Body>\n</Popover>';

var EXAMPLE_BUTTON = '<Popover.Container>\n    <Button onClick={event => this.setState({ open: !this.state.open })}>\n        Toggle Popover\n    </Button>\n    {this.state.open? (<Popover>\n        <Popover.Heading title="Hello" />\n        <Popover.Body>\n            Inner body of the popover.\n        </Popover.Body>\n    </Popover>) : null}\n</Popover.Container>';

var EXAMPLE_POSITION = '<div>{\n    [\n        \'top\',\n        \'top-right\',\n        \'right\',\n        \'bottom-right\',\n        \'bottom\',\n        \'bottom-left\',\n        \'left\',\n        \'top-left\'\n    ].map(pos =>\n        <Popover.Container key={pos}\n                           onMouseEnter={() => this.setState({ [pos]: true })}\n                           onMouseLeave={() => this.setState({ [pos]: false })}>\n            <Button >\n                {pos}\n            </Button>\n            { this.state[pos] ?\n            <Popover position={pos}>\n                <Popover.Body>{pos}</Popover.Body>\n            </Popover>\n            : null }\n        </Popover.Container>\n    )\n}</div>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Popovers', active: 'popovers' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Popovers' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Add small overlay content, like those found in iOS, to any element for housing secondary information.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With an input', source: EXAMPLE_WITH_INPUT, scope: SCOPE }),
        React.createElement(Example, { title: 'With button and state', source: EXAMPLE_BUTTON, scope: SCOPE }),
        React.createElement(Example, { title: 'With custom positioning', source: EXAMPLE_POSITION, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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