'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var Container = require('./Container');
var STYLES = require('./STYLES');

var Alert = React.createClass({
    displayName: 'Alert',

    propTypes: {
        onClose: React.PropTypes.func,
        closable: React.PropTypes.bool,
        style: React.PropTypes.oneOf(STYLES),
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            opened: true
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            onClose: undefined,
            closable: false,
            style: STYLES[0]
        };
    },
    onClose: function onClose(e) {
        e.preventDefault();
        var onClose = this.props.onClose;

        this.setState({
            opened: false
        }, function () {
            if (onClose) onClose();
        });
    },
    render: function render() {
        var style = this.props.style;
        var className = classNames('alert', 'alert-' + style, this.props.className);
        var onClose = this.props.onClose;
        var closable = this.props.closable;
        var inner = void 0;

        if (!this.state.opened) {
            return React.createElement('div', null);
        }

        if (onClose || closable) {
            inner = React.createElement(
                'a',
                { href: '#', onClick: this.onClose, className: 'alert-btn' },
                React.createElement(Icon, { id: 'x' })
            );
        }

        return React.createElement(
            'div',
            { className: className },
            React.createElement(
                Container,
                { fluid: true },
                inner,
                this.props.children
            )
        );
    }
});

var AlertButton = React.createClass({
    displayName: 'AlertButton',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string,
        href: React.PropTypes.string,
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            e.preventDefault();
            this.props.onClick();
        }
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            className = _props.className;

        className = classNames('alert-btn', className || '');
        href = href || '#';

        return React.createElement(
            'a',
            { className: className, href: href, onClick: this.onClick },
            this.props.children
        );
    }
});

/**
 * Create a style of alert
 * @param {String} style
 * @return {React.Component}
 */
function createAlertStyle(style) {
    return React.createClass({
        displayName: Alert.displayName + style,
        render: function render() {
            return React.createElement(Alert, _extends({}, this.props, { style: style.toLowerCase() }));
        }
    });
}

module.exports = Alert;
module.exports.Button = AlertButton;
module.exports.Info = createAlertStyle('Info');
module.exports.Danger = createAlertStyle('Danger');
module.exports.Success = createAlertStyle('Success');
module.exports.Warning = createAlertStyle('Warning');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9BbGVydC5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJjbGFzc05hbWVzIiwiSWNvbiIsIkNvbnRhaW5lciIsIlNUWUxFUyIsIkFsZXJ0IiwiY3JlYXRlQ2xhc3MiLCJwcm9wVHlwZXMiLCJvbkNsb3NlIiwiUHJvcFR5cGVzIiwiZnVuYyIsImNsb3NhYmxlIiwiYm9vbCIsInN0eWxlIiwib25lT2YiLCJjaGlsZHJlbiIsIm5vZGUiLCJjbGFzc05hbWUiLCJzdHJpbmciLCJnZXRJbml0aWFsU3RhdGUiLCJvcGVuZWQiLCJnZXREZWZhdWx0UHJvcHMiLCJ1bmRlZmluZWQiLCJlIiwicHJldmVudERlZmF1bHQiLCJwcm9wcyIsInNldFN0YXRlIiwicmVuZGVyIiwiaW5uZXIiLCJzdGF0ZSIsIkFsZXJ0QnV0dG9uIiwiaHJlZiIsIm9uQ2xpY2siLCJjcmVhdGVBbGVydFN0eWxlIiwiZGlzcGxheU5hbWUiLCJ0b0xvd2VyQ2FzZSIsIm1vZHVsZSIsImV4cG9ydHMiLCJCdXR0b24iLCJJbmZvIiwiRGFuZ2VyIiwiU3VjY2VzcyIsIldhcm5pbmciXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxJQUFNQSxRQUFRQyxRQUFRLE9BQVIsQ0FBZDtBQUNBLElBQU1DLGFBQWFELFFBQVEsWUFBUixDQUFuQjs7QUFFQSxJQUFNRSxPQUFPRixRQUFRLFFBQVIsQ0FBYjtBQUNBLElBQU1HLFlBQVlILFFBQVEsYUFBUixDQUFsQjtBQUNBLElBQU1JLFNBQVNKLFFBQVEsVUFBUixDQUFmOztBQUVBLElBQU1LLFFBQVFOLE1BQU1PLFdBQU4sQ0FBa0I7QUFBQTs7QUFDNUJDLGVBQVc7QUFDUEMsaUJBQVVULE1BQU1VLFNBQU4sQ0FBZ0JDLElBRG5CO0FBRVBDLGtCQUFVWixNQUFNVSxTQUFOLENBQWdCRyxJQUZuQjtBQUdQQyxlQUFVZCxNQUFNVSxTQUFOLENBQWdCSyxLQUFoQixDQUFzQlYsTUFBdEIsQ0FISDtBQUlQVyxrQkFBVWhCLE1BQU1VLFNBQU4sQ0FBZ0JPLElBSm5CO0FBS1BDLG1CQUFXbEIsTUFBTVUsU0FBTixDQUFnQlM7QUFMcEIsS0FEaUI7O0FBUzVCQyxtQkFUNEIsNkJBU1Y7QUFDZCxlQUFPO0FBQ0hDLG9CQUFRO0FBREwsU0FBUDtBQUdILEtBYjJCO0FBZTVCQyxtQkFmNEIsNkJBZVY7QUFDZCxlQUFPO0FBQ0hiLHFCQUFTYyxTQUROO0FBRUhYLHNCQUFVLEtBRlA7QUFHSEUsbUJBQU9ULE9BQU8sQ0FBUDtBQUhKLFNBQVA7QUFLSCxLQXJCMkI7QUF1QjVCSSxXQXZCNEIsbUJBdUJwQmUsQ0F2Qm9CLEVBdUJqQjtBQUNQQSxVQUFFQyxjQUFGO0FBQ0EsWUFBTWhCLFVBQVUsS0FBS2lCLEtBQUwsQ0FBV2pCLE9BQTNCOztBQUVBLGFBQUtrQixRQUFMLENBQWM7QUFDVk4sb0JBQVE7QUFERSxTQUFkLEVBRUcsWUFBVztBQUNWLGdCQUFJWixPQUFKLEVBQWFBO0FBQ2hCLFNBSkQ7QUFLSCxLQWhDMkI7QUFrQzVCbUIsVUFsQzRCLG9CQWtDbkI7QUFDTCxZQUFNZCxRQUFZLEtBQUtZLEtBQUwsQ0FBV1osS0FBN0I7QUFDQSxZQUFNSSxZQUFZaEIsV0FBVyxPQUFYLEVBQW9CLFdBQVdZLEtBQS9CLEVBQXNDLEtBQUtZLEtBQUwsQ0FBV1IsU0FBakQsQ0FBbEI7QUFDQSxZQUFNVCxVQUFZLEtBQUtpQixLQUFMLENBQVdqQixPQUE3QjtBQUNBLFlBQU1HLFdBQVksS0FBS2MsS0FBTCxDQUFXZCxRQUE3QjtBQUNBLFlBQUlpQixjQUFKOztBQUVBLFlBQUksQ0FBQyxLQUFLQyxLQUFMLENBQVdULE1BQWhCLEVBQXdCO0FBQ3BCLG1CQUFPLGdDQUFQO0FBQ0g7O0FBRUQsWUFBSVosV0FBV0csUUFBZixFQUF5QjtBQUNyQmlCLG9CQUFRO0FBQUE7QUFBQSxrQkFBRyxNQUFLLEdBQVIsRUFBWSxTQUFTLEtBQUtwQixPQUExQixFQUFtQyxXQUFVLFdBQTdDO0FBQXlELG9DQUFDLElBQUQsSUFBTSxJQUFHLEdBQVQ7QUFBekQsYUFBUjtBQUNIOztBQUVELGVBQ0k7QUFBQTtBQUFBLGNBQUssV0FBV1MsU0FBaEI7QUFDSTtBQUFDLHlCQUFEO0FBQUEsa0JBQVcsV0FBWDtBQUNDVyxxQkFERDtBQUVDLHFCQUFLSCxLQUFMLENBQVdWO0FBRlo7QUFESixTQURKO0FBUUg7QUF6RDJCLENBQWxCLENBQWQ7O0FBNERBLElBQU1lLGNBQWMvQixNQUFNTyxXQUFOLENBQWtCO0FBQUE7O0FBQ2xDQyxlQUFXO0FBQ1BRLGtCQUFVaEIsTUFBTVUsU0FBTixDQUFnQk8sSUFEbkI7QUFFUEMsbUJBQVdsQixNQUFNVSxTQUFOLENBQWdCUyxNQUZwQjtBQUdQYSxjQUFNaEMsTUFBTVUsU0FBTixDQUFnQlMsTUFIZjtBQUlQYyxpQkFBVWpDLE1BQU1VLFNBQU4sQ0FBZ0JDO0FBSm5CLEtBRHVCOztBQVFsQ3NCLFdBUmtDLG1CQVExQlQsQ0FSMEIsRUFRdkI7QUFDUCxZQUFJLEtBQUtFLEtBQUwsQ0FBV08sT0FBZixFQUF3QjtBQUNwQlQsY0FBRUMsY0FBRjtBQUNBLGlCQUFLQyxLQUFMLENBQVdPLE9BQVg7QUFDSDtBQUNKLEtBYmlDO0FBZWxDTCxVQWZrQyxvQkFlekI7QUFBQSxxQkFDcUIsS0FBS0YsS0FEMUI7QUFBQSxZQUNDTSxJQURELFVBQ0NBLElBREQ7QUFBQSxZQUNPZCxTQURQLFVBQ09BLFNBRFA7O0FBRUxBLG9CQUFZaEIsV0FBVyxXQUFYLEVBQXdCZ0IsYUFBYSxFQUFyQyxDQUFaO0FBQ0FjLGVBQU9BLFFBQVEsR0FBZjs7QUFFQSxlQUNJO0FBQUE7QUFBQSxjQUFHLFdBQVdkLFNBQWQsRUFBeUIsTUFBTWMsSUFBL0IsRUFBcUMsU0FBUyxLQUFLQyxPQUFuRDtBQUE2RCxpQkFBS1AsS0FBTCxDQUFXVjtBQUF4RSxTQURKO0FBR0g7QUF2QmlDLENBQWxCLENBQXBCOztBQTBCQTs7Ozs7QUFLQSxTQUFTa0IsZ0JBQVQsQ0FBMEJwQixLQUExQixFQUFpQztBQUM3QixXQUFPZCxNQUFNTyxXQUFOLENBQWtCO0FBQ3JCNEIscUJBQWE3QixNQUFNNkIsV0FBTixHQUFvQnJCLEtBRFo7QUFFckJjLGNBRnFCLG9CQUVaO0FBQ0wsbUJBQU8sb0JBQUMsS0FBRCxlQUFXLEtBQUtGLEtBQWhCLElBQXVCLE9BQU9aLE1BQU1zQixXQUFOLEVBQTlCLElBQVA7QUFDSDtBQUpvQixLQUFsQixDQUFQO0FBTUg7O0FBRURDLE9BQU9DLE9BQVAsR0FBeUJoQyxLQUF6QjtBQUNBK0IsT0FBT0MsT0FBUCxDQUFlQyxNQUFmLEdBQXlCUixXQUF6QjtBQUNBTSxPQUFPQyxPQUFQLENBQWVFLElBQWYsR0FBeUJOLGlCQUFpQixNQUFqQixDQUF6QjtBQUNBRyxPQUFPQyxPQUFQLENBQWVHLE1BQWYsR0FBeUJQLGlCQUFpQixRQUFqQixDQUF6QjtBQUNBRyxPQUFPQyxPQUFQLENBQWVJLE9BQWYsR0FBeUJSLGlCQUFpQixTQUFqQixDQUF6QjtBQUNBRyxPQUFPQyxPQUFQLENBQWVLLE9BQWYsR0FBeUJULGlCQUFpQixTQUFqQixDQUF6QiIsImZpbGUiOiJBbGVydC5qcyIsInNvdXJjZVJvb3QiOiIvVXNlcnMvanByZXluYXQvR2l0Qm9vay9zdHlsZWd1aWRlIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuY29uc3QgY2xhc3NOYW1lcyA9IHJlcXVpcmUoJ2NsYXNzbmFtZXMnKTtcblxuY29uc3QgSWNvbiA9IHJlcXVpcmUoJy4vSWNvbicpO1xuY29uc3QgQ29udGFpbmVyID0gcmVxdWlyZSgnLi9Db250YWluZXInKTtcbmNvbnN0IFNUWUxFUyA9IHJlcXVpcmUoJy4vU1RZTEVTJyk7XG5cbmNvbnN0IEFsZXJ0ID0gUmVhY3QuY3JlYXRlQ2xhc3Moe1xuICAgIHByb3BUeXBlczoge1xuICAgICAgICBvbkNsb3NlOiAgUmVhY3QuUHJvcFR5cGVzLmZ1bmMsXG4gICAgICAgIGNsb3NhYmxlOiBSZWFjdC5Qcm9wVHlwZXMuYm9vbCxcbiAgICAgICAgc3R5bGU6ICAgIFJlYWN0LlByb3BUeXBlcy5vbmVPZihTVFlMRVMpLFxuICAgICAgICBjaGlsZHJlbjogUmVhY3QuUHJvcFR5cGVzLm5vZGUsXG4gICAgICAgIGNsYXNzTmFtZTogUmVhY3QuUHJvcFR5cGVzLnN0cmluZ1xuICAgIH0sXG5cbiAgICBnZXRJbml0aWFsU3RhdGUoKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBvcGVuZWQ6IHRydWVcbiAgICAgICAgfTtcbiAgICB9LFxuXG4gICAgZ2V0RGVmYXVsdFByb3BzKCkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgb25DbG9zZTogdW5kZWZpbmVkLFxuICAgICAgICAgICAgY2xvc2FibGU6IGZhbHNlLFxuICAgICAgICAgICAgc3R5bGU6IFNUWUxFU1swXVxuICAgICAgICB9O1xuICAgIH0sXG5cbiAgICBvbkNsb3NlKGUpIHtcbiAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICBjb25zdCBvbkNsb3NlID0gdGhpcy5wcm9wcy5vbkNsb3NlO1xuXG4gICAgICAgIHRoaXMuc2V0U3RhdGUoe1xuICAgICAgICAgICAgb3BlbmVkOiBmYWxzZVxuICAgICAgICB9LCBmdW5jdGlvbigpIHtcbiAgICAgICAgICAgIGlmIChvbkNsb3NlKSBvbkNsb3NlKCk7XG4gICAgICAgIH0pO1xuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIGNvbnN0IHN0eWxlICAgICA9IHRoaXMucHJvcHMuc3R5bGU7XG4gICAgICAgIGNvbnN0IGNsYXNzTmFtZSA9IGNsYXNzTmFtZXMoJ2FsZXJ0JywgJ2FsZXJ0LScgKyBzdHlsZSwgdGhpcy5wcm9wcy5jbGFzc05hbWUpO1xuICAgICAgICBjb25zdCBvbkNsb3NlICAgPSB0aGlzLnByb3BzLm9uQ2xvc2U7XG4gICAgICAgIGNvbnN0IGNsb3NhYmxlICA9IHRoaXMucHJvcHMuY2xvc2FibGU7XG4gICAgICAgIGxldCBpbm5lcjtcblxuICAgICAgICBpZiAoIXRoaXMuc3RhdGUub3BlbmVkKSB7XG4gICAgICAgICAgICByZXR1cm4gPGRpdiAvPjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChvbkNsb3NlIHx8IGNsb3NhYmxlKSB7XG4gICAgICAgICAgICBpbm5lciA9IDxhIGhyZWY9XCIjXCIgb25DbGljaz17dGhpcy5vbkNsb3NlfSBjbGFzc05hbWU9XCJhbGVydC1idG5cIj48SWNvbiBpZD1cInhcIiAvPjwvYT47XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9e2NsYXNzTmFtZX0+XG4gICAgICAgICAgICAgICAgPENvbnRhaW5lciBmbHVpZD5cbiAgICAgICAgICAgICAgICB7aW5uZXJ9XG4gICAgICAgICAgICAgICAge3RoaXMucHJvcHMuY2hpbGRyZW59XG4gICAgICAgICAgICAgICAgPC9Db250YWluZXI+XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgKTtcbiAgICB9XG59KTtcblxuY29uc3QgQWxlcnRCdXR0b24gPSBSZWFjdC5jcmVhdGVDbGFzcyh7XG4gICAgcHJvcFR5cGVzOiB7XG4gICAgICAgIGNoaWxkcmVuOiBSZWFjdC5Qcm9wVHlwZXMubm9kZSxcbiAgICAgICAgY2xhc3NOYW1lOiBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICBocmVmOiBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICBvbkNsaWNrOiAgUmVhY3QuUHJvcFR5cGVzLmZ1bmNcbiAgICB9LFxuXG4gICAgb25DbGljayhlKSB7XG4gICAgICAgIGlmICh0aGlzLnByb3BzLm9uQ2xpY2spIHtcbiAgICAgICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgICAgIHRoaXMucHJvcHMub25DbGljaygpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIHJlbmRlcigpIHtcbiAgICAgICAgbGV0IHsgaHJlZiwgY2xhc3NOYW1lIH0gPSB0aGlzLnByb3BzO1xuICAgICAgICBjbGFzc05hbWUgPSBjbGFzc05hbWVzKCdhbGVydC1idG4nLCBjbGFzc05hbWUgfHwgJycpO1xuICAgICAgICBocmVmID0gaHJlZiB8fCAnIyc7XG5cbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgIDxhIGNsYXNzTmFtZT17Y2xhc3NOYW1lfSBocmVmPXtocmVmfSBvbkNsaWNrPXt0aGlzLm9uQ2xpY2t9Pnt0aGlzLnByb3BzLmNoaWxkcmVufTwvYT5cbiAgICAgICAgKTtcbiAgICB9XG59KTtcblxuLyoqXG4gKiBDcmVhdGUgYSBzdHlsZSBvZiBhbGVydFxuICogQHBhcmFtIHtTdHJpbmd9IHN0eWxlXG4gKiBAcmV0dXJuIHtSZWFjdC5Db21wb25lbnR9XG4gKi9cbmZ1bmN0aW9uIGNyZWF0ZUFsZXJ0U3R5bGUoc3R5bGUpIHtcbiAgICByZXR1cm4gUmVhY3QuY3JlYXRlQ2xhc3Moe1xuICAgICAgICBkaXNwbGF5TmFtZTogQWxlcnQuZGlzcGxheU5hbWUgKyBzdHlsZSxcbiAgICAgICAgcmVuZGVyKCkge1xuICAgICAgICAgICAgcmV0dXJuIDxBbGVydCB7Li4udGhpcy5wcm9wc30gc3R5bGU9e3N0eWxlLnRvTG93ZXJDYXNlKCl9IC8+O1xuICAgICAgICB9XG4gICAgfSk7XG59XG5cbm1vZHVsZS5leHBvcnRzICAgICAgICAgPSBBbGVydDtcbm1vZHVsZS5leHBvcnRzLkJ1dHRvbiAgPSBBbGVydEJ1dHRvbjtcbm1vZHVsZS5leHBvcnRzLkluZm8gICAgPSBjcmVhdGVBbGVydFN0eWxlKCdJbmZvJyk7XG5tb2R1bGUuZXhwb3J0cy5EYW5nZXIgID0gY3JlYXRlQWxlcnRTdHlsZSgnRGFuZ2VyJyk7XG5tb2R1bGUuZXhwb3J0cy5TdWNjZXNzID0gY3JlYXRlQWxlcnRTdHlsZSgnU3VjY2VzcycpO1xubW9kdWxlLmV4cG9ydHMuV2FybmluZyA9IGNyZWF0ZUFsZXJ0U3R5bGUoJ1dhcm5pbmcnKTtcbiJdfQ==