'use strict';

var React = require('react');
var classNames = require('classnames');

var Input = require('./Input');
var Spinner = require('./Spinner');

var KEYCODE_ENTER = 13;
var KEYCODE_UP = 38;
var KEYCODE_DOWN = 40;

var Autocomplete = React.createClass({
    displayName: 'Autocomplete',

    propTypes: {
        onFetch: React.PropTypes.func.isRequired,
        renderResult: React.PropTypes.func.isRequired,
        onChange: React.PropTypes.func.isRequired,
        // Called when onEnter on the input (no result selected)
        // query -> ()
        onEnter: React.PropTypes.func.isRequired,
        onPaste: React.PropTypes.func,
        value: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        size: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            value: this.props.value || '',
            cursor: null,
            loading: false,
            focused: false,
            results: []
        };
    },


    /**
     * Typed value changed, we fetch the new autocomplete result
     */
    onInputChanged: function onInputChanged(e) {
        var that = this;
        var onFetch = this.props.onFetch;
        var value = e.target.value;

        this.setState({
            value: value,
            loading: true
        });

        onFetch(value, function (results) {
            that.setState({
                loading: false,
                results: results
            });
        });
    },


    /**
     * User is focusing/blur the input
     */
    onFocusChanged: function onFocusChanged(isFocused) {
        this.setState({
            focused: isFocused
        });
    },


    /**
     * Submit value at cursor
     */
    onEnter: function onEnter() {
        var _state = this.state,
            cursor = _state.cursor,
            value = _state.value;
        var onEnter = this.props.onEnter;

        if (cursor >= 0) {
            this.onSelect(cursor);
        } else if (onEnter) {
            onEnter(value);
            this.setState({
                focused: false,
                cursor: null,
                results: [],
                value: ''
            });
        }
    },


    /**
     * Submit a value
     */
    onSelect: function onSelect(index) {
        var onChange = this.props.onChange;
        var _state2 = this.state,
            value = _state2.value,
            results = _state2.results;

        var selected = results[index];

        this.setState({
            cursor: null,
            results: [],
            value: ''
        });

        onChange(value, selected);
    },


    /**
     * User pressed a key in text input
     */
    onKeyDown: function onKeyDown(e) {
        var _state3 = this.state,
            cursor = _state3.cursor,
            results = _state3.results;


        if (e.keyCode === KEYCODE_ENTER) {
            e.preventDefault();
            this.onEnter();
        } else if (e.keyCode === KEYCODE_DOWN) {
            e.preventDefault();
            cursor++;
        } else if (e.keyCode === KEYCODE_UP) {
            e.preventDefault();
            cursor--;
        }

        if (cursor >= results.length) {
            cursor = results.length - 1;
        }
        if (cursor < -1) {
            cursor = -1;
        }

        this.setState({
            cursor: cursor
        });
    },


    /**
     * Render the suggestions
     */
    renderResults: function renderResults() {
        var that = this;
        var _state4 = this.state,
            results = _state4.results,
            value = _state4.value,
            cursor = _state4.cursor;

        var ResultComponent = this.props.renderResult;

        return React.createElement(
            'div',
            { className: 'AutocompleteResults' },
            results.map(function (result, i) {
                var isActive = i === cursor;

                return React.createElement(
                    AutocompleteResult,
                    { key: value + '-' + i, active: isActive,
                        onClick: function onClick(e) {
                            return that.onSelect(i);
                        } },
                    React.createElement(ResultComponent, { result: result, index: i, active: isActive })
                );
            })
        );
    },
    render: function render() {
        var _this = this;

        var _props = this.props,
            onPaste = _props.onPaste,
            size = _props.size,
            placeholder = _props.placeholder;
        var _state5 = this.state,
            value = _state5.value,
            focused = _state5.focused,
            loading = _state5.loading,
            results = _state5.results;


        return React.createElement(
            'div',
            { className: 'Autocomplete' },
            React.createElement(Input, {
                value: value,
                placeholder: placeholder,
                size: size,
                onChange: this.onInputChanged,
                onFocus: function onFocus(e) {
                    return _this.onFocusChanged(true);
                },
                onBlur: function onBlur(e) {
                    return _this.onFocusChanged(false);
                },
                onPaste: onPaste,
                onKeyDown: this.onKeyDown
            }),
            loading ? React.createElement(Spinner, { size: 'sm', centered: false }) : '',
            focused && results.length > 0 ? this.renderResults() : ''
        );
    }
});

var AutocompleteResult = React.createClass({
    displayName: 'AutocompleteResult',

    propTypes: {
        active: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props2 = this.props,
            active = _props2.active,
            children = _props2.children,
            onClick = _props2.onClick;

        return React.createElement(
            'div',
            { className: classNames('AutocompleteResult', { active: active }),
                onMouseDown: onClick },
            children
        );
    }
});

module.exports = Autocomplete;
//# sourceMappingURL=data:application/json;base64,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