'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');
var AVATAR_SIZES = SIZES.concat(['button']);

var Avatar = React.createClass({
    displayName: 'Avatar',

    propTypes: {
        src: React.PropTypes.string,
        // No src fallbacks on text
        text: React.PropTypes.string,
        size: React.PropTypes.oneOf(AVATAR_SIZES),
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            src = _props.src,
            size = _props.size,
            className = _props.className,
            text = _props.text,
            children = _props.children;

        className = classNames('avatar', size ? 'avatar-' + size : '', className);

        return React.createElement(
            'figure',
            { className: className, 'data-initial': text },
            src ? React.createElement('img', { src: src }) : null,
            children
        );
    }
});

var AvatarIcon = React.createClass({
    displayName: 'AvatarIcon',

    propTypes: {
        src: React.PropTypes.string,
        className: React.PropTypes.string
    },

    render: function render() {
        var _props2 = this.props,
            src = _props2.src,
            className = _props2.className;

        className = classNames('avatar-icon', className);

        return React.createElement('img', { src: src, className: className });
    }
});

module.exports = Avatar;
module.exports.Icon = AvatarIcon;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9BdmF0YXIuanMiXSwibmFtZXMiOlsiUmVhY3QiLCJyZXF1aXJlIiwiY2xhc3NOYW1lcyIsIlNJWkVTIiwiQVZBVEFSX1NJWkVTIiwiY29uY2F0IiwiQXZhdGFyIiwiY3JlYXRlQ2xhc3MiLCJwcm9wVHlwZXMiLCJzcmMiLCJQcm9wVHlwZXMiLCJzdHJpbmciLCJ0ZXh0Iiwic2l6ZSIsIm9uZU9mIiwiY2xhc3NOYW1lIiwiY2hpbGRyZW4iLCJub2RlIiwicmVuZGVyIiwicHJvcHMiLCJBdmF0YXJJY29uIiwibW9kdWxlIiwiZXhwb3J0cyIsIkljb24iXSwibWFwcGluZ3MiOiI7O0FBQUEsSUFBTUEsUUFBUUMsUUFBUSxPQUFSLENBQWQ7QUFDQSxJQUFNQyxhQUFhRCxRQUFRLFlBQVIsQ0FBbkI7O0FBRUEsSUFBTUUsUUFBUUYsUUFBUSxTQUFSLENBQWQ7QUFDQSxJQUFNRyxlQUFlRCxNQUFNRSxNQUFOLENBQWEsQ0FBQyxRQUFELENBQWIsQ0FBckI7O0FBRUEsSUFBTUMsU0FBU04sTUFBTU8sV0FBTixDQUFrQjtBQUFBOztBQUM3QkMsZUFBVztBQUNQQyxhQUFXVCxNQUFNVSxTQUFOLENBQWdCQyxNQURwQjtBQUVQO0FBQ0FDLGNBQVdaLE1BQU1VLFNBQU4sQ0FBZ0JDLE1BSHBCO0FBSVBFLGNBQVdiLE1BQU1VLFNBQU4sQ0FBZ0JJLEtBQWhCLENBQXNCVixZQUF0QixDQUpKO0FBS1BXLG1CQUFXZixNQUFNVSxTQUFOLENBQWdCQyxNQUxwQjtBQU1QSyxrQkFBV2hCLE1BQU1VLFNBQU4sQ0FBZ0JPO0FBTnBCLEtBRGtCOztBQVU3QkMsVUFWNkIsb0JBVXBCO0FBQUEscUJBQzBDLEtBQUtDLEtBRC9DO0FBQUEsWUFDQ1YsR0FERCxVQUNDQSxHQUREO0FBQUEsWUFDTUksSUFETixVQUNNQSxJQUROO0FBQUEsWUFDWUUsU0FEWixVQUNZQSxTQURaO0FBQUEsWUFDdUJILElBRHZCLFVBQ3VCQSxJQUR2QjtBQUFBLFlBQzZCSSxRQUQ3QixVQUM2QkEsUUFEN0I7O0FBRUxELG9CQUFZYixXQUFXLFFBQVgsRUFBcUJXLE9BQU8sWUFBWUEsSUFBbkIsR0FBMEIsRUFBL0MsRUFBbURFLFNBQW5ELENBQVo7O0FBRUEsZUFDSTtBQUFBO0FBQUEsY0FBUSxXQUFXQSxTQUFuQixFQUE4QixnQkFBY0gsSUFBNUM7QUFDTUgsa0JBQU0sNkJBQUssS0FBS0EsR0FBVixHQUFOLEdBQTBCLElBRGhDO0FBRUtPO0FBRkwsU0FESjtBQU1IO0FBcEI0QixDQUFsQixDQUFmOztBQXVCQSxJQUFNSSxhQUFhcEIsTUFBTU8sV0FBTixDQUFrQjtBQUFBOztBQUNqQ0MsZUFBVztBQUNQQyxhQUFLVCxNQUFNVSxTQUFOLENBQWdCQyxNQURkO0FBRVBJLG1CQUFXZixNQUFNVSxTQUFOLENBQWdCQztBQUZwQixLQURzQjs7QUFNakNPLFVBTmlDLG9CQU14QjtBQUFBLHNCQUNvQixLQUFLQyxLQUR6QjtBQUFBLFlBQ0NWLEdBREQsV0FDQ0EsR0FERDtBQUFBLFlBQ01NLFNBRE4sV0FDTUEsU0FETjs7QUFFTEEsb0JBQVliLFdBQVcsYUFBWCxFQUEwQmEsU0FBMUIsQ0FBWjs7QUFFQSxlQUFPLDZCQUFLLEtBQUtOLEdBQVYsRUFBZSxXQUFXTSxTQUExQixHQUFQO0FBQ0g7QUFYZ0MsQ0FBbEIsQ0FBbkI7O0FBY0FNLE9BQU9DLE9BQVAsR0FBaUJoQixNQUFqQjtBQUNBZSxPQUFPQyxPQUFQLENBQWVDLElBQWYsR0FBc0JILFVBQXRCIiwiZmlsZSI6IkF2YXRhci5qcyIsInNvdXJjZVJvb3QiOiIvVXNlcnMvanByZXluYXQvR2l0Qm9vay9zdHlsZWd1aWRlIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuY29uc3QgY2xhc3NOYW1lcyA9IHJlcXVpcmUoJ2NsYXNzbmFtZXMnKTtcblxuY29uc3QgU0laRVMgPSByZXF1aXJlKCcuL1NJWkVTJyk7XG5jb25zdCBBVkFUQVJfU0laRVMgPSBTSVpFUy5jb25jYXQoWydidXR0b24nXSk7XG5cbmNvbnN0IEF2YXRhciA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICBwcm9wVHlwZXM6IHtcbiAgICAgICAgc3JjOiAgICAgICBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICAvLyBObyBzcmMgZmFsbGJhY2tzIG9uIHRleHRcbiAgICAgICAgdGV4dDogICAgICBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICBzaXplOiAgICAgIFJlYWN0LlByb3BUeXBlcy5vbmVPZihBVkFUQVJfU0laRVMpLFxuICAgICAgICBjbGFzc05hbWU6IFJlYWN0LlByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIGNoaWxkcmVuOiAgUmVhY3QuUHJvcFR5cGVzLm5vZGVcbiAgICB9LFxuXG4gICAgcmVuZGVyKCkge1xuICAgICAgICBsZXQgeyBzcmMsIHNpemUsIGNsYXNzTmFtZSwgdGV4dCwgY2hpbGRyZW4gfSA9IHRoaXMucHJvcHM7XG4gICAgICAgIGNsYXNzTmFtZSA9IGNsYXNzTmFtZXMoJ2F2YXRhcicsIHNpemUgPyAnYXZhdGFyLScgKyBzaXplIDogJycsIGNsYXNzTmFtZSk7XG5cbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgIDxmaWd1cmUgY2xhc3NOYW1lPXtjbGFzc05hbWV9IGRhdGEtaW5pdGlhbD17dGV4dH0+XG4gICAgICAgICAgICAgICAgeyBzcmMgPyA8aW1nIHNyYz17c3JjfSAvPiA6IG51bGwgfVxuICAgICAgICAgICAgICAgIHtjaGlsZHJlbn1cbiAgICAgICAgICAgIDwvZmlndXJlPlxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG5jb25zdCBBdmF0YXJJY29uID0gUmVhY3QuY3JlYXRlQ2xhc3Moe1xuICAgIHByb3BUeXBlczoge1xuICAgICAgICBzcmM6IFJlYWN0LlByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIGNsYXNzTmFtZTogUmVhY3QuUHJvcFR5cGVzLnN0cmluZ1xuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIGxldCB7IHNyYywgY2xhc3NOYW1lIH0gPSB0aGlzLnByb3BzO1xuICAgICAgICBjbGFzc05hbWUgPSBjbGFzc05hbWVzKCdhdmF0YXItaWNvbicsIGNsYXNzTmFtZSk7XG5cbiAgICAgICAgcmV0dXJuIDxpbWcgc3JjPXtzcmN9IGNsYXNzTmFtZT17Y2xhc3NOYW1lfSAvPjtcbiAgICB9XG59KTtcblxubW9kdWxlLmV4cG9ydHMgPSBBdmF0YXI7XG5tb2R1bGUuZXhwb3J0cy5JY29uID0gQXZhdGFySWNvbjtcbiJdfQ==