"use strict";

var React = require('react');

/**
 * An item in the stack
 * @type {ReactClass}
 */
var AvatarsStackItem = React.createClass({
    displayName: "AvatarsStackItem",

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        var children = this.props.children;


        return React.createElement(
            "div",
            { className: "AvatarsStack-Item" },
            children
        );
    }
});

/**
 * Stack of avatars to display a list of participants.
 * @type {ReactClass}
 */
var AvatarsStack = React.createClass({
    displayName: "AvatarsStack",

    propTypes: {
        children: React.PropTypes.node
    },
    statics: {
        Item: AvatarsStackItem
    },

    render: function render() {
        var children = this.props.children;


        return React.createElement(
            "div",
            { className: "AvatarsStack" },
            children
        );
    }
});

module.exports = AvatarsStack;
//# sourceMappingURL=data:application/json;base64,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