'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var STYLES = require('./STYLES');
var SIZES = require('./SIZES');

var BUTTONS_STYLES = STYLES.concat(['link', 'marketing-primary', 'secondary', 'count']);

var Button = React.createClass({
    displayName: 'Button',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        type: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES),
        style: React.PropTypes.oneOf(BUTTONS_STYLES),
        // Makes a link button
        href: React.PropTypes.string,
        // Form button
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
        name: React.PropTypes.string,
        // For links
        target: React.PropTypes.string,
        filled: React.PropTypes.bool,
        noBorder: React.PropTypes.bool,
        disabled: React.PropTypes.bool,
        active: React.PropTypes.bool,
        block: React.PropTypes.bool,
        dropdownToggle: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        title: React.PropTypes.string,
        icon: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            clicked: false
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            style: 'default',
            size: 'md',
            type: 'button',
            filled: false,
            disabled: false,
            active: false
        };
    },
    onClick: function onClick(e) {
        var _this = this;

        // Prevent any action if button is disabled
        var disabled = this.props.disabled;

        if (disabled) {
            e.preventDefault();
            return;
        }

        var clicked = this.state.clicked;

        if (this.props.onClick && !clicked) {
            this.props.onClick(e);
        }

        if (!this.isFormButton()) {
            return;
        } else if (clicked) {
            return this.setState({
                clicked: false
            });
        }

        // Add this submitting button's value to the form as hidden
        // input. Only after that do the click.
        // This fixes issues with PJAX[1] in Firefox[2]
        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
        e.preventDefault();
        this.setState({
            clicked: true
        }, function () {
            _this.refs.button.click();
        });
    },
    isFormButton: function isFormButton() {
        var _props = this.props,
            type = _props.type,
            name = _props.name;

        return type === 'submit' && name;
    },
    render: function render() {
        var clicked = this.state.clicked;

        var _props2 = this.props,
            title = _props2.title,
            icon = _props2.icon,
            filled = _props2.filled,
            block = _props2.block,
            noBorder = _props2.noBorder,
            active = _props2.active,
            dropdownToggle = _props2.dropdownToggle,
            style = _props2.style,
            size = _props2.size,
            className = _props2.className,
            children = _props2.children,
            name = _props2.name,
            value = _props2.value,
            disabled = _props2.disabled,
            props = _objectWithoutProperties(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value', 'disabled']);

        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
            'btn-fill': filled,
            'btn-block': block,
            'btn-noborder': noBorder,
            active: active, disabled: disabled,
            'dropdown-toggle': dropdownToggle,
            'tooltipped': Boolean(title)
        });
        props['aria-label'] = title;
        props.role = 'button';
        props.disabled = disabled;
        props.onClick = this.onClick;
        // Update href if button is disabled
        if (props.href) {
            props.href = disabled ? '#' : props.href;
        }

        var input = void 0;

        if (clicked && this.isFormButton()) {
            input = React.createElement('input', { type: 'hidden', name: name, value: value });
        }

        if (props.href) {
            delete props.type;
            return React.createElement(
                'a',
                props,
                inner,
                ' ',
                children
            );
        } else {
            return React.createElement(
                'button',
                _extends({ ref: 'button' }, props),
                inner,
                ' ',
                children,
                input
            );
        }
    }
});

var ButtonGroup = React.createClass({
    displayName: 'ButtonGroup',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        pull: React.PropTypes.string,
        block: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            className = _props3.className,
            pull = _props3.pull,
            children = _props3.children,
            block = _props3.block,
            props = _objectWithoutProperties(_props3, ['className', 'pull', 'children', 'block']);

        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
            'btn-group-block': block
        });

        return React.createElement(
            'div',
            _extends({ className: className }, props),
            children
        );
    }
});

var ButtonToolbar = React.createClass({
    displayName: 'ButtonToolbar',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props4 = this.props,
            className = _props4.className,
            children = _props4.children,
            props = _objectWithoutProperties(_props4, ['className', 'children']);

        return React.createElement(
            'div',
            _extends({ className: 'btn-toolbar ' + (className || '') }, props),
            children
        );
    }
});

var ButtonCaret = React.createClass({
    displayName: 'ButtonCaret',
    render: function render() {
        return React.createElement('span', { className: 'caret' });
    }
});

var ButtonTextExpander = React.createClass({
    displayName: 'ButtonTextExpander',

    propTypes: {
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            this.props.onClick();
        }
    },
    render: function render() {
        return React.createElement(
            'span',
            { className: 'hidden-text-expander' },
            React.createElement(
                'button',
                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
                '\u2026'
            )
        );
    }
});

module.exports = Button;
module.exports.Group = ButtonGroup;
module.exports.Toolbar = ButtonToolbar;
module.exports.Caret = ButtonCaret;
module.exports.TextExpander = ButtonTextExpander;
module.exports.STYLES = BUTTONS_STYLES;
//# sourceMappingURL=data:application/json;base64,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