'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Container = React.createClass({
    displayName: 'Container',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        // No hoz padding
        fluid: React.PropTypes.bool,
        // Take all the width
        maxWidth: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            maxWidth: false,
            fluid: false
        };
    },
    render: function render() {
        var _props = this.props,
            fluid = _props.fluid,
            className = _props.className,
            maxWidth = _props.maxWidth,
            props = _objectWithoutProperties(_props, ['fluid', 'className', 'maxWidth']);

        className = classNames('container', {
            'container-fluid': fluid,
            'container-max-width': maxWidth
        }, className);

        return React.createElement(
            'div',
            _extends({}, props, { className: className }),
            this.props.children
        );
    }
});

module.exports = Container;
//# sourceMappingURL=data:application/json;base64,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