'use strict';

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var ReactDOM = require('react-dom');
var classNames = require('classnames');

var Backdrop = require('./Backdrop');

var MENU_RIGHT_SPACING = 300;
var MENU_BOTTOM_SPACING = 160;

/**
 * Helper to display a context menu.
 *
 *  <ContextMenu component={() => <Dropdown></Dropdown>}>
 *    Right click here !
 *  </ContextMenu>
 *
 * @type {ReactClass}
 */
var ContextMenu = React.createClass({
    displayName: 'ContextMenu',

    propTypes: {
        component: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired
    },

    getInitialState: function getInitialState() {
        return {
            open: false,
            x: 0,
            y: 0,
            directionH: 'e'
        };
    },


    /**
     * When user is opening context menu.
     */
    onOpen: function onOpen(event) {
        event.preventDefault();
        event.stopPropagation();

        var x = event.clientX;
        var y = event.clientY;

        var width = window.innerWidth;
        var height = window.innerHeight;

        this.setState({
            open: true,
            x: x,
            y: y,
            directionH: x > width - MENU_RIGHT_SPACING ? 'w' : 'e',
            directionV: y > height - MENU_BOTTOM_SPACING ? 'n' : 's'
        });
    },


    /**
     * When user is closing the menu.
     */
    onClose: function onClose() {
        this.setState({
            open: false
        });
    },


    /**
     * Close the menu after any click on the window.
     * We wait next event loop to avoid hiding the menu before the click got propaged to it.
     */
    onWindowClick: function onWindowClick() {
        var _this = this;

        setTimeout(function () {
            return _this.onClose();
        }, 1);
    },
    bindEvents: function bindEvents() {
        var el = ReactDOM.findDOMNode(this);
        el.addEventListener('contextmenu', this.onOpen, false);
        el.addEventListener('click', this.onWindowClick, false);
    },
    unbindEvents: function unbindEvents() {
        var el = ReactDOM.findDOMNode(this);
        el.removeEventListener('contextmenu', this.onOpen, false);
        el.removeEventListener('click', this.onWindowClick, false);
    },
    componentDidMount: function componentDidMount() {
        this.bindEvents();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.unbindEvents();
    },
    componentWillUpdate: function componentWillUpdate() {
        this.unbindEvents();
    },
    componentDidUpdate: function componentDidUpdate() {
        this.bindEvents();
    },
    render: function render() {
        var _props = this.props,
            children = _props.children,
            component = _props.component,
            otherProps = _objectWithoutProperties(_props, ['children', 'component']);

        var _state = this.state,
            open = _state.open,
            x = _state.x,
            y = _state.y,
            directionH = _state.directionH,
            directionV = _state.directionV;


        var inner = React.Children.only(children);

        if (!open) {
            return inner;
        }

        var menu = React.createElement(component, otherProps);

        return React.createElement(
            Backdrop,
            { wrapper: inner, onClose: this.onClose },
            React.createElement(
                'div',
                {
                    className: classNames('ContextMenu', 'direction-' + directionH, 'direction-' + directionV),
                    style: { top: y, left: x },
                    onClick: this.onClick },
                menu
            )
        );
    }
});

module.exports = ContextMenu;
//# sourceMappingURL=data:application/json;base64,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