'use strict';

var React = require('react');
var classNames = require('classnames');

var FilterItem = React.createClass({
    displayName: 'FilterItem',

    propTypes: {
        children: React.PropTypes.node,
        selected: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        count: React.PropTypes.number,
        onClick: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            selected: false,
            href: '#'
        };
    },
    onClick: function onClick(e) {
        if (!this.props.onClick) {
            return;
        }

        e.preventDefault();
        this.props.onClick();
    },
    render: function render() {
        var className = classNames('filter-item', this.props.className, {
            selected: this.props.selected
        });
        var count = this.props.count;
        var href = this.props.href;
        var inner = '';

        if (typeof count !== 'undefined') {
            inner = React.createElement(
                'span',
                { className: 'count' },
                count
            );
        }

        return React.createElement(
            'li',
            null,
            React.createElement(
                'a',
                { className: className, href: href, onClick: this.onClick },
                inner,
                this.props.children
            )
        );
    }
});

var FilterList = React.createClass({
    displayName: 'FilterList',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'ul',
            { className: 'filter-list' },
            this.props.children
        );
    }
});

module.exports = FilterList;
module.exports.Item = FilterItem;
//# sourceMappingURL=data:application/json;base64,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