'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var classNames = require('classnames');

/**
 * Main container for a form
 * @type {ReactClass}
 */
var Form = React.createClass({
    displayName: 'Form',

    propTypes: {
        children: React.PropTypes.node
    },

    submit: function submit() {
        this.refs.form.submit();
    },
    render: function render() {
        return React.createElement(
            'form',
            _extends({ ref: 'form' }, this.props),
            this.props.children
        );
    }
});

/**
 * Container for an input, its label and help text.
 * @type {ReactClass}
 */
var FormGroup = React.createClass({
    displayName: 'FormGroup',

    propTypes: {
        error: React.PropTypes.bool,
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaulProps: function getDefaulProps() {
        return {
            error: false
        };
    },
    render: function render() {
        var className = classNames('form-group', {
            'has-error': this.props.error
        }, this.props.className);

        return React.createElement(
            'div',
            { className: className },
            this.props.children
        );
    }
});

/**
 * An help text for an input
 * @type {ReactClass}
 */
var FormHelpBlock = React.createClass({
    displayName: 'FormHelpBlock',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'p',
            { className: 'help-block' },
            this.props.children
        );
    }
});

/**
 * Container for submit/cancel actions
 * @type {ReactClass}
 */
var FormActions = React.createClass({
    displayName: 'FormActions',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'form-actions' },
            this.props.children
        );
    }
});

module.exports = Form;
module.exports.Actions = FormActions;
module.exports.Group = FormGroup;
module.exports.HelpBlock = FormHelpBlock;
//# sourceMappingURL=data:application/json;base64,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