'use strict';

var React = require('react');
var classNames = require('classnames');

var ListItem = React.createClass({
    displayName: 'ListItem',

    propTypes: {
        active: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        onClick: React.PropTypes.func,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: '#'
        };
    },
    onClick: function onClick(e) {
        if (!this.props.onClick) {
            return;
        }

        e.preventDefault();
        this.props.onClick();
    },
    render: function render() {
        var className = classNames('list-group-item', this.props.className, {
            active: this.props.active
        });

        return React.createElement(
            'a',
            { href: this.props.href, className: className, onClick: this.onClick },
            this.props.children
        );
    }
});

var ListGroup = React.createClass({
    displayName: 'ListGroup',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'ul',
            { className: 'list-group' },
            this.props.children
        );
    }
});

module.exports = ListGroup;
module.exports.Item = ListItem;
//# sourceMappingURL=data:application/json;base64,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