'use strict';

var React = require('react');
var classNames = require('classnames');

/**
 *   <Menu>
 *       <Menu.Item>...</Menu.Item>
 *       <Menu.Item>...</Menu.Item>
 *       <Menu.Item>...</Menu.Item>
 *   </Menu>
 */
var MenuItem = React.createClass({
    displayName: 'MenuItem',

    propTypes: {
        active: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        onClick: React.PropTypes.func,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: null
        };
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            onClick = _props.onClick;

        var className = classNames(this.props.className || '', {
            'active': this.props.active
        });

        return React.createElement(
            'li',
            { className: className },
            React.createElement(
                'a',
                { href: href || '#', onClick: onClick },
                this.props.children
            )
        );
    }
});

var Menu = React.createClass({
    displayName: 'Menu',

    propTypes: {
        right: React.PropTypes.bool,
        left: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: null
        };
    },
    render: function render() {
        var className = classNames('menu', {
            'pull-right': this.props.right,
            'pull-left': this.props.left
        });

        return React.createElement(
            'ul',
            { className: className },
            this.props.children
        );
    }
});

module.exports = Menu;
module.exports.Item = MenuItem;
//# sourceMappingURL=data:application/json;base64,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