'use strict';

var React = require('react');
var Menu = require('./Menu');
var Logo = require('../icons/Logo');

/**
 * Logo of GitBook in the footer
 * @type {ReactClass}
 */
var FooterLogo = React.createClass({
    displayName: 'FooterLogo',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'footer-logo' },
            React.createElement(Logo, null)
        );
    }
});

/**
 * Copyright in the footer
 * @type {ReactClass}
 */
var FooterCopyright = React.createClass({
    displayName: 'FooterCopyright',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            Menu.Item,
            { href: 'https://www.gitbook.com', className: 'footer-copyright' },
            '\xA9 GitBook.com'
        );
    }
});

/**
 * Container for the footer.
 * @type {ReactClass}
 */
var PageFooter = React.createClass({
    displayName: 'PageFooter',

    statics: {
        Copyright: FooterCopyright,
        Logo: FooterLogo
    },

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'gb-page-footer' },
            this.props.children
        );
    }
});

module.exports = PageFooter;
//# sourceMappingURL=data:application/json;base64,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