'use strict';

var React = require('react');
var classNames = require('classnames');

var STYLES = require('./STYLES');

var Panel = React.createClass({
    displayName: 'Panel',

    propTypes: {
        style: React.PropTypes.oneOf(STYLES),
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            style: STYLES[0]
        };
    },
    render: function render() {
        var style = this.props.style;

        return React.createElement(
            'div',
            { className: classNames('panel', 'panel-' + style) },
            this.props.children
        );
    }
});

var PanelHeading = React.createClass({
    displayName: 'PanelHeading',

    propTypes: {
        title: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var title = this.props.title;
        var inner = '';

        if (title) {
            inner = React.createElement(
                PanelTitle,
                null,
                title
            );
        }

        return React.createElement(
            'div',
            { className: 'panel-heading' },
            inner,
            this.props.children
        );
    }
});

var PanelTitle = React.createClass({
    displayName: 'PanelTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'h3',
            { className: 'panel-title' },
            this.props.children
        );
    }
});

var PanelToolbar = React.createClass({
    displayName: 'PanelToolbar',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'panel-toolbar' },
            this.props.children
        );
    }
});

var PanelBody = React.createClass({
    displayName: 'PanelBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'panel-body' },
            this.props.children
        );
    }
});

module.exports = Panel;
module.exports.Heading = PanelHeading;
module.exports.Title = PanelTitle;
module.exports.Body = PanelBody;
module.exports.Toolbar = PanelToolbar;
//# sourceMappingURL=data:application/json;base64,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