'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Link = require('./Link');

var POSITIONS = ['top', 'top-right', 'right', 'bottom-right', 'bottom', 'bottom-left', 'left', 'top-left'];

/**
 * Pop content with controls over content:
 *
 * <Popover.Container>
 *   <Button>Open</Button>
 *   {open?
 *      <Popover>
 *         <Popover.Heading title="Hello" />
 *         <Popover.Body>...</Popover.Body>
 *         <Popover.Controls>
 *           <Popover.Control onClick={...}>Say Hello</Popover.Control>
 *           <Popover.Control onClick={...}>Say World</Popover.Control>
 *         </Popover.Controls>
 *      </Popover>
 *   : null}
 * </Popover.Container>
 */

var Popover = React.createClass({
    displayName: 'Popover',

    propTypes: {
        position: React.PropTypes.oneOf(POSITIONS),
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            position: 'bottom'
        };
    },
    render: function render() {
        var position = this.props.position;

        var className = classNames('popover', 'popover-' + position);

        return React.createElement(
            'div',
            { className: 'popover-wrapper' },
            React.createElement(
                'div',
                { className: className },
                React.createElement(
                    PopoverCard,
                    null,
                    React.createElement('div', { className: 'popover-arrow' }),
                    this.props.children
                )
            )
        );
    }
});

var PopoverContainer = React.createClass({
    displayName: 'PopoverContainer',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            className = _props.className,
            props = _objectWithoutProperties(_props, ['className']);

        className = classNames('popover-container', className);

        return React.createElement(
            'div',
            _extends({ className: className }, props),
            this.props.children
        );
    }
});

// The actual element that looks like a popup card.
var PopoverCard = React.createClass({
    displayName: 'PopoverCard',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            _extends({ className: 'popover-card' }, this.props),
            this.props.children
        );
    }
});

var PopoverBody = React.createClass({
    displayName: 'PopoverBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-body' },
            this.props.children
        );
    }
});

var PopoverTitle = React.createClass({
    displayName: 'PopoverTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-title' },
            this.props.children
        );
    }
});

var PopoverHeading = React.createClass({
    displayName: 'PopoverHeading',

    propTypes: {
        title: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props2 = this.props,
            title = _props2.title,
            children = _props2.children;


        if (title) {
            children = React.createElement(
                PopoverTitle,
                null,
                title
            );
        }

        return React.createElement(
            'div',
            { className: 'popover-heading' },
            children
        );
    }
});

var PopoverControl = React.createClass({
    displayName: 'PopoverControl',

    propTypes: {
        children: React.PropTypes.node,
        onClick: React.PropTypes.func,
        active: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            onClick = _props3.onClick,
            children = _props3.children,
            active = _props3.active;

        var className = classNames('control', { active: active });

        return React.createElement(
            Link,
            { className: className, onClick: onClick },
            children
        );
    }
});

var PopoverControls = React.createClass({
    displayName: 'PopoverControls',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-controls' },
            this.props.children
        );
    }
});

module.exports = Popover;
module.exports.Card = PopoverCard;
module.exports.Body = PopoverBody;
module.exports.Heading = PopoverHeading;
module.exports.Title = PopoverTitle;
module.exports.Container = PopoverContainer;
module.exports.Control = PopoverControl;
module.exports.Controls = PopoverControls;
//# sourceMappingURL=data:application/json;base64,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